/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.Map;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.command.CommandConfigurable;
import net.citizensnpcs.command.CommandContext;
import net.citizensnpcs.trait.Toggleable;
import net.citizensnpcs.util.Util;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityPlayer;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

public class Controllable
extends Trait
implements Toggleable,
CommandConfigurable {
    private Controller controller = new GroundController();
    private boolean enabled;
    private EntityType explicitType;
    private static final Map<EntityType, Class<? extends Controller>> controllerTypes = Maps.newEnumMap(EntityType.class);

    public Controllable() {
        super("controllable");
    }

    @Override
    public void configure(CommandContext args) {
        if (args.hasFlag('f')) {
            this.explicitType = EntityType.BLAZE;
        } else if (args.hasFlag('g')) {
            this.explicitType = EntityType.OCELOT;
        } else if (args.hasFlag('r')) {
            this.explicitType = null;
        } else if (args.hasValueFlag("explicittype")) {
            this.explicitType = Util.matchEntityType(args.getFlag("explicittype"));
        }
        if (this.npc.isSpawned()) {
            this.loadController();
        }
    }

    private void enterOrLeaveVehicle(Player player) {
        EntityPlayer handle = ((CraftPlayer)player).getHandle();
        if (this.getHandle().passenger != null) {
            if (this.getHandle().passenger == handle) {
                player.leaveVehicle();
            }
            return;
        }
        handle.setPassengerOf((Entity)this.getHandle());
    }

    private EntityLiving getHandle() {
        return ((CraftLivingEntity)this.npc.getBukkitEntity()).getHandle();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.enabled = key.getBoolean("enabled");
        this.explicitType = Util.matchEntityType(key.getString("explicittype"));
    }

    private void loadController() {
        Class<? extends Controller> clazz;
        EntityType type = this.npc.getBukkitEntity().getType();
        if (this.explicitType != null) {
            type = this.explicitType;
        }
        if ((clazz = controllerTypes.get(type)) == null) {
            this.controller = new GroundController();
            return;
        }
        Constructor<? extends Controller> innerConstructor = null;
        try {
            innerConstructor = clazz.getConstructor(Controllable.class);
            innerConstructor.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.controller = innerConstructor == null ? clazz.newInstance() : innerConstructor.newInstance(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller = new GroundController();
        }
    }

    public boolean mount(Player toMount) {
        if (this.npc.getBukkitEntity().getPassenger() != null) {
            return false;
        }
        ((CraftPlayer)toMount).getHandle().setPassengerOf((Entity)this.getHandle());
        return true;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.npc.isSpawned() || !this.enabled) {
            return;
        }
        EntityPlayer handle = ((CraftPlayer)event.getPlayer()).getHandle();
        Action performed = event.getAction();
        if (!handle.equals((Object)this.getHandle().passenger)) {
            return;
        }
        switch (performed) {
            case RIGHT_CLICK_BLOCK: 
            case RIGHT_CLICK_AIR: {
                this.controller.rightClick(event);
                break;
            }
            case LEFT_CLICK_BLOCK: 
            case LEFT_CLICK_AIR: {
                this.controller.leftClick(event);
                break;
            }
        }
    }

    @EventHandler
    public void onRightClick(NPCRightClickEvent event) {
        if (!(this.enabled && this.npc.isSpawned() && event.getNPC().equals(this.npc))) {
            return;
        }
        this.controller.rightClickEntity(event);
    }

    @Override
    public void onSpawn() {
        this.loadController();
    }

    @Override
    public void run() {
        if (!this.enabled || !this.npc.isSpawned() || this.getHandle().passenger == null) {
            return;
        }
        this.controller.run((Player)this.getHandle().passenger.getBukkitEntity());
    }

    @Override
    public void save(DataKey key) {
        key.setBoolean("enabled", this.enabled);
        if (this.explicitType == null) {
            key.removeKey("explicittype");
        } else {
            key.setString("explicittype", this.explicitType.name());
        }
    }

    @Override
    public boolean toggle() {
        boolean bl = this.enabled = !this.enabled;
        if (!this.enabled && this.getHandle().passenger != null) {
            this.getHandle().passenger.getBukkitEntity().leaveVehicle();
        }
        return this.enabled;
    }

    static {
        controllerTypes.put(EntityType.BAT, AirController.class);
        controllerTypes.put(EntityType.BLAZE, AirController.class);
        controllerTypes.put(EntityType.ENDER_DRAGON, AirController.class);
        controllerTypes.put(EntityType.GHAST, AirController.class);
        controllerTypes.put(EntityType.WITHER, AirController.class);
    }

    public class GroundController
    implements Controller {
        private static final float AIR_SPEED = 1.5f;
        private static final float GROUND_SPEED = 4.0f;
        private static final float JUMP_VELOCITY = 0.6f;

        private void jump() {
            boolean allowed = ((Controllable)Controllable.this).getHandle().onGround;
            if (!allowed) {
                return;
            }
            ((Controllable)Controllable.this).getHandle().motY = 0.6f;
        }

        @Override
        public void leftClick(PlayerInteractEvent event) {
            this.jump();
        }

        @Override
        public void rightClick(PlayerInteractEvent event) {
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent event) {
            Controllable.this.enterOrLeaveVehicle(event.getClicker());
        }

        @Override
        public void run(Player rider) {
            EntityLiving handle = Controllable.this.getHandle();
            boolean onGround = handle.onGround;
            float speedMod = Controllable.this.npc.getNavigator().getDefaultParameters().modifiedSpeed(onGround ? 4.0f : 1.5f);
            handle.motX += handle.passenger.motX * (double)speedMod;
            handle.motZ += handle.passenger.motZ * (double)speedMod;
        }
    }

    public static interface Controller {
        public void leftClick(PlayerInteractEvent var1);

        public void rightClick(PlayerInteractEvent var1);

        public void rightClickEntity(NPCRightClickEvent var1);

        public void run(Player var1);
    }

    public class AirController
    implements Controller {
        boolean paused = false;

        @Override
        public void leftClick(PlayerInteractEvent event) {
            this.paused = !this.paused;
        }

        @Override
        public void rightClick(PlayerInteractEvent event) {
            this.paused = !this.paused;
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent event) {
            Controllable.this.enterOrLeaveVehicle(event.getClicker());
        }

        @Override
        public void run(Player rider) {
            if (this.paused) {
                ((Controllable)Controllable.this).getHandle().motY = 0.001;
                return;
            }
            Vector dir = rider.getEyeLocation().getDirection();
            dir.multiply(Controllable.this.npc.getNavigator().getDefaultParameters().speedModifier());
            EntityLiving handle = Controllable.this.getHandle();
            handle.motX = dir.getX();
            handle.motY = dir.getY();
            handle.motZ = dir.getZ();
        }
    }
}

