/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import net.citizensnpcs.Metrics;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitFactory;
import net.citizensnpcs.api.trait.TraitInfo;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.trait.Age;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.trait.Behaviour;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.Poses;
import net.citizensnpcs.trait.Powered;
import net.citizensnpcs.trait.Saddle;
import net.citizensnpcs.trait.Sheared;
import net.citizensnpcs.trait.SkeletonType;
import net.citizensnpcs.trait.SlimeSize;
import net.citizensnpcs.trait.VillagerProfession;
import net.citizensnpcs.trait.WoolColor;
import net.citizensnpcs.trait.text.Text;
import net.citizensnpcs.trait.waypoint.Waypoints;

public class CitizensTraitFactory
implements TraitFactory {
    private final Map<String, Class<? extends Trait>> registered = Maps.newHashMap();
    private static final Set<String> INTERNAL_TRAITS = Sets.newHashSet();

    public CitizensTraitFactory() {
        this.registerTrait(TraitInfo.create(Age.class).withName("age"));
        this.registerTrait(TraitInfo.create(Anchors.class).withName("anchors"));
        this.registerTrait(TraitInfo.create(Behaviour.class).withName("behaviour"));
        this.registerTrait(TraitInfo.create(Controllable.class).withName("controllable"));
        this.registerTrait(TraitInfo.create(Equipment.class).withName("equipment"));
        this.registerTrait(TraitInfo.create(Gravity.class).withName("gravity"));
        this.registerTrait(TraitInfo.create(Inventory.class).withName("inventory"));
        this.registerTrait(TraitInfo.create(CurrentLocation.class).withName("location"));
        this.registerTrait(TraitInfo.create(LookClose.class).withName("lookclose"));
        this.registerTrait(TraitInfo.create(Owner.class).withName("owner"));
        this.registerTrait(TraitInfo.create(Poses.class).withName("poses"));
        this.registerTrait(TraitInfo.create(Powered.class).withName("powered"));
        this.registerTrait(TraitInfo.create(VillagerProfession.class).withName("profession"));
        this.registerTrait(TraitInfo.create(Saddle.class).withName("saddle"));
        this.registerTrait(TraitInfo.create(Sheared.class).withName("sheared"));
        this.registerTrait(TraitInfo.create(SkeletonType.class).withName("skeletontype"));
        this.registerTrait(TraitInfo.create(SlimeSize.class).withName("slimesize"));
        this.registerTrait(TraitInfo.create(Spawned.class).withName("spawned"));
        this.registerTrait(TraitInfo.create(Text.class).withName("text"));
        this.registerTrait(TraitInfo.create(MobType.class).withName("type"));
        this.registerTrait(TraitInfo.create(Waypoints.class).withName("waypoints"));
        this.registerTrait(TraitInfo.create(WoolColor.class).withName("woolcolor"));
        for (String trait : this.registered.keySet()) {
            INTERNAL_TRAITS.add(trait);
        }
    }

    public void addPlotters(Metrics.Graph graph) {
        for (Map.Entry<String, Class<? extends Trait>> entry : this.registered.entrySet()) {
            if (INTERNAL_TRAITS.contains(entry.getKey())) continue;
            final Class<? extends Trait> traitClass = entry.getValue();
            graph.addPlotter(new Metrics.Plotter(entry.getKey()){

                @Override
                public int getValue() {
                    int numberUsingTrait = 0;
                    for (NPC npc : CitizensAPI.getNPCRegistry()) {
                        if (!npc.hasTrait(traitClass)) continue;
                        ++numberUsingTrait;
                    }
                    return numberUsingTrait;
                }
            });
        }
    }

    private <T extends Trait> T create(Class<T> trait) {
        try {
            return (T)((Trait)trait.newInstance());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public <T extends Trait> T getTrait(Class<T> clazz) {
        if (!this.registered.containsValue(clazz)) {
            return null;
        }
        return this.create(clazz);
    }

    @Override
    public <T extends Trait> T getTrait(String name) {
        Class<? extends Trait> clazz = this.registered.get(name);
        if (clazz == null) {
            return null;
        }
        return (T)this.create(clazz);
    }

    @Override
    public Class<? extends Trait> getTraitClass(String name) {
        return this.registered.get(name.toLowerCase());
    }

    @Override
    public boolean isInternalTrait(Trait trait) {
        return INTERNAL_TRAITS.contains(trait.getName());
    }

    @Override
    public void registerTrait(TraitInfo info) {
        Preconditions.checkNotNull((Object)info, (Object)"info cannot be null");
        if (this.registered.containsKey(info)) {
            throw new IllegalArgumentException("trait name already registered");
        }
        this.registered.put(info.getTraitName(), info.getTraitClass());
    }
}

