/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.base.Splitter;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.event.NPCCollisionEvent;
import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Pose;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.Packet;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class Util {
    private Util() {
    }

    public static void assumePose(Entity entity, Pose pose) {
        EntityLiving handle = ((CraftLivingEntity)entity).getHandle();
        NMS.look(handle, pose.getYaw(), pose.getPitch());
    }

    public static void callCollisionEvent(NPC npc, net.minecraft.server.Entity entity) {
        if (NPCCollisionEvent.getHandlerList().getRegisteredListeners().length > 0) {
            Bukkit.getPluginManager().callEvent((Event)new NPCCollisionEvent(npc, entity.getBukkitEntity()));
        }
    }

    public static NPCPushEvent callPushEvent(NPC npc, Vector vector) {
        NPCPushEvent event = new NPCPushEvent(npc, vector);
        event.setCancelled(npc.data().get("protected", true));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void faceEntity(Entity from, Entity at) {
        if (from.getWorld() != at.getWorld()) {
            return;
        }
        Location loc = from.getLocation();
        double xDiff = at.getLocation().getX() - loc.getX();
        double yDiff = at.getLocation().getY() - loc.getY();
        double zDiff = at.getLocation().getZ() - loc.getZ();
        double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        double distanceY = Math.sqrt(distanceXZ * distanceXZ + yDiff * yDiff);
        double yaw = Math.acos(xDiff / distanceXZ) * 180.0 / Math.PI;
        double pitch = Math.acos(yDiff / distanceY) * 180.0 / Math.PI - 90.0;
        if (zDiff < 0.0) {
            yaw += Math.abs(180.0 - yaw) * 2.0;
        }
        EntityLiving handle = ((CraftLivingEntity)from).getHandle();
        NMS.look(handle, (float)yaw - 90.0f, (float)pitch);
    }

    public static boolean isSettingFulfilled(Player player, Settings.Setting setting) {
        String parts = setting.asString();
        if (parts.contains("*")) {
            return true;
        }
        for (String part : Splitter.on((char)',').split((CharSequence)parts)) {
            if (Material.matchMaterial((String)part) != player.getItemInHand().getType()) continue;
            return true;
        }
        return false;
    }

    public static EntityType matchEntityType(String toMatch) {
        EntityType type = EntityType.fromName((String)toMatch);
        if (type != null) {
            return type;
        }
        for (EntityType check : EntityType.values()) {
            String name = check.name();
            if (!name.matches(toMatch) && !name.equalsIgnoreCase(toMatch) && !name.replace("_", "").equalsIgnoreCase(toMatch) && !name.replace('_', '-').equalsIgnoreCase(toMatch) && !name.replace('_', ' ').equalsIgnoreCase(toMatch) && !name.startsWith(toMatch)) continue;
            type = check;
            break;
        }
        return type;
    }

    public static void sendPacketNearby(Location location, Packet packet, double radius) {
        radius *= radius;
        World world = location.getWorld();
        for (Player ply : Bukkit.getServer().getOnlinePlayers()) {
            if (ply == null || world != ply.getWorld() || location.distanceSquared(ply.getLocation()) > radius) continue;
            ((CraftPlayer)ply).getHandle().netServerHandler.sendPacket(packet);
        }
    }

    public static void sendToOnline(Packet ... packets) {
        Validate.notNull((Object)packets, (String)"packets cannot be null");
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player == null || !player.isOnline()) continue;
            for (Packet packet : packets) {
                ((CraftPlayer)player).getHandle().netServerHandler.sendPacket(packet);
            }
        }
    }
}

