/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.SimpleGoalEntry;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.scripting.CompileCallback;
import net.citizensnpcs.api.scripting.Script;
import net.citizensnpcs.api.scripting.ScriptFactory;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;

public class Behaviour
extends Trait {
    private final List<BehaviourGoalEntry> addedGoals = Lists.newArrayList();
    private final Function<String, File> fileConverterFunction = new Function<String, File>(){

        public File apply(String arg0) {
            return new File(Behaviour.this.rootFolder, arg0);
        }
    };
    private final File rootFolder = new File(CitizensAPI.getScriptFolder(), "behaviours");
    private final List<File> scripts = Lists.newArrayList();

    public Behaviour() {
        super("behaviour");
        if (!this.rootFolder.exists()) {
            this.rootFolder.mkdirs();
        }
    }

    public void addScripts(Iterable<String> scripts) {
        BehaviourCallback callback = new BehaviourCallback();
        Iterable transformed = Iterables.transform(scripts, this.fileConverterFunction);
        CitizensAPI.getScriptCompiler().compile(transformed).withCallback(callback).begin();
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.reset();
        if (!key.keyExists("scripts")) {
            return;
        }
        String scripts = key.getString("scripts");
        this.addScripts(Splitter.on((char)',').split((CharSequence)scripts));
    }

    @Override
    public void onRemove() {
        this.removeGoals();
    }

    @Override
    public void onSpawn() {
        for (BehaviourGoalEntry entry : this.addedGoals) {
            this.npc.getDefaultGoalController().addGoal(entry.getGoal(), entry.getPriority());
        }
    }

    private void removeGoals() {
        for (BehaviourGoalEntry entry : this.addedGoals) {
            this.npc.getDefaultGoalController().removeGoal(entry.getGoal());
        }
    }

    public void removeScripts(Iterable<String> files) {
        Iterable transformed = Iterables.transform(files, this.fileConverterFunction);
        boolean isSpawned = this.npc.isSpawned();
        for (File file : transformed) {
            if (isSpawned) {
                Iterator<BehaviourGoalEntry> itr = this.addedGoals.iterator();
                while (itr.hasNext()) {
                    BehaviourGoalEntry entry = itr.next();
                    if (!file.equals(entry.file)) continue;
                    itr.remove();
                    this.npc.getDefaultGoalController().removeGoal(entry.getGoal());
                }
            }
            this.scripts.remove(file);
        }
    }

    private void reset() {
        this.removeGoals();
        this.scripts.clear();
        this.addedGoals.clear();
    }

    @Override
    public void save(DataKey key) {
        key.removeKey("scripts");
        StringBuilder fileNames = new StringBuilder();
        for (File file : this.scripts) {
            fileNames.append(file.getName() + ',');
        }
        if (fileNames.length() > 0) {
            key.setString("scripts", fileNames.substring(0, fileNames.length() - 1));
        }
    }

    private static class BehaviourGoalEntry
    extends SimpleGoalEntry {
        private final File file;

        private BehaviourGoalEntry(Goal goal, int priority, File file) {
            super(goal, priority);
            this.file = file;
        }
    }

    public class BehaviourCallback
    implements CompileCallback {
        private File fileInUse;
        private final List<BehaviourGoalEntry> goals = Lists.newArrayList();

        public void addGoal(int priority, Goal goal) {
            Validate.notNull((Object)goal);
            this.goals.add(new BehaviourGoalEntry(goal, priority, this.fileInUse));
        }

        @Override
        public void onCompileTaskFinished() {
            Behaviour.this.addedGoals.addAll(this.goals);
            if (!Behaviour.this.npc.isSpawned()) {
                return;
            }
            for (BehaviourGoalEntry entry : this.goals) {
                Behaviour.this.npc.getDefaultGoalController().addGoal(entry.getGoal(), entry.getPriority());
            }
        }

        @Override
        public void onScriptCompiled(final File file, ScriptFactory script) {
            final Script instance = script.newInstance();
            Bukkit.getScheduler().callSyncMethod(CitizensAPI.getPlugin(), (Callable)new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() throws Exception {
                    Behaviour behaviour = Behaviour.this;
                    synchronized (behaviour) {
                        BehaviourCallback.this.fileInUse = file;
                        instance.invoke("addGoals", this, Behaviour.this.npc);
                        Behaviour.this.scripts.add(file);
                        BehaviourCallback.this.fileInUse = null;
                    }
                    return null;
                }
            });
        }
    }
}

