/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.util.PlayerAnimation;
import net.minecraft.server.v1_6_R2.Enchantment;
import net.minecraft.server.v1_6_R2.EnchantmentManager;
import net.minecraft.server.v1_6_R2.EntityLiving;
import net.minecraft.server.v1_6_R2.EntityPlayer;
import net.minecraft.server.v1_6_R2.Material;
import net.minecraft.server.v1_6_R2.MobEffectList;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_6_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_6_R2.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BlockBreaker
extends BehaviorGoalAdapter {
    private final Configuration configuration;
    private int currentDamage;
    private int currentTick;
    private final EntityLiving entity;
    private boolean isDigging;
    private int startDigTick;
    private final int x;
    private final int y;
    private final int z;
    private static final Configuration EMPTY = new Configuration();

    private BlockBreaker(LivingEntity entity, Block target, Configuration config) {
        this.entity = ((CraftLivingEntity)entity).getHandle();
        this.x = target.getX();
        this.y = target.getY();
        this.z = target.getZ();
        this.startDigTick = (int)(System.currentTimeMillis() / 50L);
        this.configuration = config;
    }

    private double distanceSquared() {
        return Math.pow(this.entity.locX - (double)this.x, 2.0) + Math.pow(this.entity.locY - (double)this.y, 2.0) + Math.pow(this.entity.locZ - (double)this.z, 2.0);
    }

    private net.minecraft.server.v1_6_R2.ItemStack getCurrentItem() {
        return this.configuration.item() != null ? CraftItemStack.asNMSCopy((ItemStack)this.configuration.item()) : this.entity.getEquipment(0);
    }

    private float getStrength(net.minecraft.server.v1_6_R2.Block block) {
        float base = block.l(null, 0, 0, 0);
        return base < 0.0f ? 0.0f : (!this.isDestroyable(block) ? 1.0f / base / 100.0f : this.strengthMod(block) / base / 30.0f);
    }

    private boolean isDestroyable(net.minecraft.server.v1_6_R2.Block block) {
        if (block.material.isAlwaysDestroyable()) {
            return true;
        }
        net.minecraft.server.v1_6_R2.ItemStack current = this.getCurrentItem();
        return current != null ? current.b(block) : false;
    }

    public boolean isFinished() {
        return !this.isDigging;
    }

    @Override
    public void reset() {
        if (this.configuration.callback() != null) {
            this.configuration.callback().run();
        }
        this.isDigging = false;
        this.currentDamage = -1;
        this.setBlockDamage(-1);
    }

    @Override
    public BehaviorStatus run() {
        net.minecraft.server.v1_6_R2.Block block;
        if (!this.isDigging) {
            this.reset();
            return BehaviorStatus.SUCCESS;
        }
        this.currentTick = (int)(System.currentTimeMillis() / 50L);
        if (this.configuration.radiusSquared() > 0.0 && this.distanceSquared() >= this.configuration.radiusSquared()) {
            this.startDigTick = this.currentTick;
            return BehaviorStatus.RUNNING;
        }
        if (this.entity instanceof EntityPlayer) {
            PlayerAnimation.ARM_SWING.play((Player)this.entity.getBukkitEntity());
        }
        if ((block = net.minecraft.server.v1_6_R2.Block.byId[this.entity.world.getTypeId(this.x, this.y, this.z)]) == null) {
            return BehaviorStatus.SUCCESS;
        }
        int tickDifference = this.currentTick - this.startDigTick;
        float damage = this.getStrength(block) * (float)(tickDifference + 1);
        if (damage >= 1.0f) {
            this.entity.world.getWorld().getBlockAt(this.x, this.y, this.z).breakNaturally((ItemStack)CraftItemStack.asCraftMirror((net.minecraft.server.v1_6_R2.ItemStack)this.getCurrentItem()));
            return BehaviorStatus.SUCCESS;
        }
        int modifiedDamage = (int)(damage * 10.0f);
        if (modifiedDamage != this.currentDamage) {
            this.setBlockDamage(modifiedDamage);
            this.currentDamage = modifiedDamage;
        }
        return BehaviorStatus.RUNNING;
    }

    private void setBlockDamage(int modifiedDamage) {
        this.entity.world.f(this.entity.id, this.x, this.y, this.z, modifiedDamage);
    }

    @Override
    public boolean shouldExecute() {
        return org.bukkit.Material.getMaterial((int)this.entity.world.getTypeId(this.x, this.y, this.z)) != null;
    }

    private float strengthMod(net.minecraft.server.v1_6_R2.Block block) {
        net.minecraft.server.v1_6_R2.ItemStack itemstack = this.getCurrentItem();
        float strength = itemstack != null ? itemstack.a(block) : 1.0f;
        int ench = EnchantmentManager.getEnchantmentLevel((int)Enchantment.DURABILITY.id, (net.minecraft.server.v1_6_R2.ItemStack)this.getCurrentItem());
        if (ench > 0 && itemstack != null) {
            float levelSquared = ench * ench + 1;
            strength = !itemstack.b(block) && strength <= 1.0f ? (strength += levelSquared * 0.08f) : (strength += levelSquared);
        }
        if (this.entity.hasEffect(MobEffectList.FASTER_DIG)) {
            strength *= 1.0f + (float)(this.entity.getEffect(MobEffectList.FASTER_DIG).getAmplifier() + 1) * 0.2f;
        }
        if (this.entity.hasEffect(MobEffectList.SLOWER_DIG)) {
            strength *= 1.0f - (float)(this.entity.getEffect(MobEffectList.SLOWER_DIG).getAmplifier() + 1) * 0.2f;
        }
        if (this.entity.a(Material.WATER) && !EnchantmentManager.hasWaterWorkerEnchantment((EntityLiving)this.entity)) {
            strength /= 5.0f;
        }
        if (!this.entity.onGround) {
            strength /= 5.0f;
        }
        return strength;
    }

    public static BlockBreaker create(LivingEntity entity, Block target) {
        return BlockBreaker.createWithConfiguration(entity, target, EMPTY);
    }

    public static BlockBreaker createWithConfiguration(LivingEntity entity, Block target, Configuration config) {
        return new BlockBreaker(entity, target, config);
    }

    public static class Configuration {
        private Runnable callback;
        private ItemStack itemStack;
        private double radius;

        private Runnable callback() {
            return this.callback;
        }

        public Configuration callback(Runnable callback) {
            this.callback = callback;
            return this;
        }

        private ItemStack item() {
            return this.itemStack;
        }

        public Configuration item(ItemStack stack) {
            this.itemStack = stack;
            return this;
        }

        public Configuration radius(double radius) {
            this.radius = radius;
            return this;
        }

        private double radiusSquared() {
            return Math.pow(this.radius, 2.0);
        }
    }
}

