/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.MobEntityController;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_6_R2.Entity;
import net.minecraft.server.v1_6_R2.EntityHuman;
import net.minecraft.server.v1_6_R2.EntityVillager;
import net.minecraft.server.v1_6_R2.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_6_R2.CraftServer;
import org.bukkit.craftbukkit.v1_6_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_6_R2.entity.CraftVillager;
import org.bukkit.entity.Villager;
import org.bukkit.util.Vector;

public class VillagerController
extends MobEntityController {
    public VillagerController() {
        super(EntityVillagerNPC.class);
    }

    public Villager getBukkitEntity() {
        return (Villager)super.getBukkitEntity();
    }

    public static class VillagerNPC
    extends CraftVillager
    implements NPCHolder {
        private final CitizensNPC npc;

        public VillagerNPC(EntityVillagerNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityVillager)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EntityVillagerNPC
    extends EntityVillager
    implements NPCHolder {
        private boolean blockTrades = true;
        private final CitizensNPC npc;

        public EntityVillagerNPC(World world) {
            this(world, null);
        }

        public EntityVillagerNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        public boolean a(EntityHuman entityhuman) {
            return this.npc == null || !this.blockTrades ? super.a(entityhuman) : false;
        }

        public void bh() {
            super.bh();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public boolean bH() {
            if (this.npc == null) {
                return super.bH();
            }
            boolean protectedDefault = this.npc.data().get("protected", true);
            if (!protectedDefault || !this.npc.data().get("protected-leash", protectedDefault).booleanValue()) {
                return super.bH();
            }
            if (super.bH()) {
                this.a(true, false);
            }
            return false;
        }

        public void collide(Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new VillagerNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean isBlockingTrades() {
            return this.blockTrades;
        }

        public void setBlockTrades(boolean blocked) {
            this.blockTrades = blocked;
        }
    }
}

