/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.ItemStack;

public class HorseModifiers
extends Trait {
    @Persist(value="armor")
    private ItemStack armor = null;
    @Persist(value="carryingChest")
    private boolean carryingChest;
    @Persist(value="color")
    private Horse.Color color = Horse.Color.CREAMY;
    @Persist(value="saddle")
    private ItemStack saddle = null;
    @Persist(value="style")
    private Horse.Style style = Horse.Style.NONE;
    @Persist(value="type")
    private Horse.Variant type = Horse.Variant.HORSE;

    public HorseModifiers() {
        super("horsemodifiers");
    }

    public Horse.Color getColor() {
        return this.color;
    }

    public Horse.Style getStyle() {
        return this.style;
    }

    public Horse.Variant getType() {
        return this.type;
    }

    @Override
    public void onSpawn() {
        this.updateModifiers();
    }

    @Override
    public void run() {
        if (this.npc.getBukkitEntity() instanceof Horse) {
            Horse horse = (Horse)this.npc.getBukkitEntity();
            this.saddle = horse.getInventory().getSaddle();
            this.armor = horse.getInventory().getArmor();
        }
    }

    public void setCarryingChest(boolean carryingChest) {
        this.carryingChest = carryingChest;
        this.updateModifiers();
    }

    public void setColor(Horse.Color color) {
        this.color = color;
        this.updateModifiers();
    }

    public void setStyle(Horse.Style style) {
        this.style = style;
        this.updateModifiers();
    }

    public void setType(Horse.Variant type) {
        this.type = type;
        this.updateModifiers();
    }

    private void updateModifiers() {
        if (this.npc.getBukkitEntity() instanceof Horse) {
            Horse horse = (Horse)this.npc.getBukkitEntity();
            horse.setCarryingChest(this.carryingChest);
            horse.setColor(this.color);
            horse.setStyle(this.style);
            horse.setVariant(this.type);
            horse.getInventory().setArmor(this.armor);
            horse.getInventory().setSaddle(this.saddle);
        }
    }
}

