/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.goals.WanderGoal;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.waypoint.WaypointEditor;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import org.bukkit.entity.Player;

public class WanderWaypointProvider
implements WaypointProvider {
    private Goal currentGoal;
    private volatile boolean paused;
    @Persist
    private final int xrange = 3;
    @Persist
    private final int yrange = 25;
    private static final int DEFAULT_XRANGE = 3;
    private static final int DEFAULT_YRANGE = 25;

    @Override
    public WaypointEditor createEditor(Player player, CommandContext args) {
        return new WaypointEditor(){

            @Override
            public void begin() {
            }

            @Override
            public void end() {
            }
        };
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void load(DataKey key) {
    }

    @Override
    public void onSpawn(NPC npc) {
        if (this.currentGoal == null) {
            this.currentGoal = WanderGoal.createWithNPCAndRange(npc, 3, 25);
            CitizensAPI.registerEvents(this.currentGoal);
        }
        npc.getDefaultGoalController().addGoal(this.currentGoal, 1);
    }

    @Override
    public void save(DataKey key) {
    }

    @Override
    public void setPaused(boolean paused) {
        this.paused = paused;
    }
}

