/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.Random;
import net.citizensnpcs.api.event.NPCCollisionEvent;
import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.XORShiftRNG;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class Util {
    private static final Location AT_LOCATION = new Location(null, 0.0, 0.0, 0.0);
    private static final Location FROM_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    private Util() {
    }

    public static void assumePose(LivingEntity entity, float yaw, float pitch) {
        NMS.look(entity, yaw, pitch);
    }

    public static void callCollisionEvent(NPC npc, Entity entity) {
        if (NPCCollisionEvent.getHandlerList().getRegisteredListeners().length > 0) {
            Bukkit.getPluginManager().callEvent((Event)new NPCCollisionEvent(npc, entity));
        }
    }

    public static NPCPushEvent callPushEvent(NPC npc, Vector vector) {
        NPCPushEvent event = new NPCPushEvent(npc, vector);
        event.setCancelled(npc.data().get("protected", true));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void faceEntity(LivingEntity from, LivingEntity at) {
        if (from.getWorld() != at.getWorld()) {
            return;
        }
        Util.faceLocation(from, at.getLocation(AT_LOCATION));
    }

    public static void faceLocation(LivingEntity from, Location to) {
        if (from.getWorld() != to.getWorld()) {
            return;
        }
        Location fromLocation = from.getLocation(FROM_LOCATION);
        double xDiff = to.getX() - fromLocation.getX();
        double yDiff = to.getY() - fromLocation.getY();
        double zDiff = to.getZ() - fromLocation.getZ();
        double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        double distanceY = Math.sqrt(distanceXZ * distanceXZ + yDiff * yDiff);
        double yaw = Math.toDegrees(Math.acos(xDiff / distanceXZ));
        double pitch = Math.toDegrees(Math.acos(yDiff / distanceY)) - 90.0;
        if (zDiff < 0.0) {
            yaw += Math.abs(180.0 - yaw) * 2.0;
        }
        NMS.look(from, (float)yaw - 90.0f, (float)pitch);
    }

    public static Random getFastRandom() {
        return new XORShiftRNG();
    }

    public static String getMinecraftVersion() {
        String raw = Bukkit.getVersion();
        int start = raw.indexOf("MC:");
        if (start == -1) {
            return raw;
        }
        int end = raw.indexOf(41, start += 4);
        return raw.substring(start, end);
    }

    public static boolean isLoaded(Location location) {
        if (location.getWorld() == null) {
            return false;
        }
        int chunkX = location.getBlockX() >> 4;
        int chunkZ = location.getBlockZ() >> 4;
        return location.getWorld().isChunkLoaded(chunkX, chunkZ);
    }

    public static String listValuesPretty(Enum<?>[] values) {
        return Joiner.on((String)", ").join((Object[])values).toLowerCase().replace('_', ' ');
    }

    public static boolean locationWithinRange(Location current, Location target, double range) {
        if (current == null || target == null) {
            return false;
        }
        if (current.getWorld() != target.getWorld()) {
            return false;
        }
        return current.distanceSquared(target) < Math.pow(range, 2.0);
    }

    public static EntityType matchEntityType(String toMatch) {
        EntityType type = EntityType.fromName((String)toMatch);
        if (type != null) {
            return type;
        }
        return (EntityType)Util.matchEnum((Enum[])EntityType.values(), (String)toMatch);
    }

    public static <T extends Enum<?>> T matchEnum(T[] values, String toMatch) {
        toMatch = toMatch.toLowerCase().replace('-', '_').replace(' ', '_');
        for (T check : values) {
            if (!toMatch.equals(((Enum)check).name().toLowerCase())) continue;
            return check;
        }
        for (T check : values) {
            String name = ((Enum)check).name().toLowerCase();
            if (!name.replace("_", "").equals(toMatch) && !name.matches(toMatch) && !name.startsWith(toMatch)) continue;
            return check;
        }
        return null;
    }

    public static boolean matchesItemInHand(Player player, String setting) {
        String parts = setting;
        if (parts.contains("*")) {
            return true;
        }
        for (String part : Splitter.on((char)',').split((CharSequence)parts)) {
            if (Material.matchMaterial((String)part) != player.getItemInHand().getType()) continue;
            return true;
        }
        return false;
    }

    public static String prettyEnum(Enum<?> e) {
        return e.name().toLowerCase().replace('_', ' ');
    }
}

