/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import net.citizensnpcs.api.astar.pathfinder.CachingChunkBlockSource;
import net.citizensnpcs.api.util.BoundingBox;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class ChunkBlockSource
extends CachingChunkBlockSource<Chunk> {
    private static boolean SUPPORT_BOUNDING_BOX = true;
    private static boolean SUPPORT_GET_TYPE = true;

    public ChunkBlockSource(Location location, float radius) {
        super(location, radius);
    }

    public ChunkBlockSource(World world, int x, int z, float radius) {
        super(world, x, z, radius);
    }

    @Override
    protected Chunk getChunkObject(int x, int z) {
        return this.world.getChunkAt(x, z);
    }

    @Override
    protected BoundingBox getCollisionBox(Chunk chunk, int x, int y, int z) {
        if (!SUPPORT_BOUNDING_BOX) {
            return null;
        }
        return BoundingBox.convert(this.world.getBlockAt(x, y, z).getBoundingBox());
    }

    @Override
    protected int getLightLevel(Chunk chunk, int x, int y, int z) {
        return chunk.getBlock(x, y, z).getLightLevel();
    }

    @Override
    protected Material getType(Chunk chunk, int x, int y, int z) {
        return SUPPORT_GET_TYPE ? this.world.getType(x, y, z) : chunk.getBlock(x & 0xF, y, z & 0xF).getType();
    }

    static {
        try {
            Class.forName("org.bukkit.RegionAccessor").getMethod("getType", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            SUPPORT_GET_TYPE = false;
        }
        try {
            Block.class.getMethod("getBoundingBox", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            SUPPORT_BOUNDING_BOX = false;
        }
    }
}

