/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import ch.ethz.globis.phtree.PhTreeHelper;
import clib.net.byteflux.libby.BukkitLibraryManager;
import clib.net.byteflux.libby.Library;
import clib.net.byteflux.libby.logging.LogLevel;
import com.comphenix.protocol.ProtocolLibrary;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.citizensnpcs.CitizensPlaceholders;
import net.citizensnpcs.EventListen;
import net.citizensnpcs.Metrics;
import net.citizensnpcs.PaymentListener;
import net.citizensnpcs.ProtocolLibListener;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.CitizensPlugin;
import net.citizensnpcs.api.LocationLookup;
import net.citizensnpcs.api.NMSHelper;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.astar.pathfinder.AsyncChunkCache;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.command.Injector;
import net.citizensnpcs.api.event.CitizensEnableEvent;
import net.citizensnpcs.api.event.CitizensPreReloadEvent;
import net.citizensnpcs.api.event.CitizensReloadEvent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.npc.SimpleNPCDataStore;
import net.citizensnpcs.api.npc.templates.TemplateRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitFactory;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.api.util.Translator;
import net.citizensnpcs.api.util.YamlStorage;
import net.citizensnpcs.commands.AdminCommands;
import net.citizensnpcs.commands.EditorCommands;
import net.citizensnpcs.commands.NPCCommands;
import net.citizensnpcs.commands.TemplateCommands;
import net.citizensnpcs.commands.TraitCommands;
import net.citizensnpcs.commands.WaypointCommands;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.CitizensNPCRegistry;
import net.citizensnpcs.npc.CitizensTraitFactory;
import net.citizensnpcs.npc.NPCSelector;
import net.citizensnpcs.npc.skin.Skin;
import net.citizensnpcs.npc.skin.profile.ProfileFetcher;
import net.citizensnpcs.trait.shop.StoredShops;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerUpdateTask;
import net.citizensnpcs.util.SkinProperty;
import net.citizensnpcs.util.Util;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Citizens
extends JavaPlugin
implements CitizensPlugin {
    private final List<NPCRegistry> anonymousRegistries = Lists.newArrayList();
    private AsyncChunkCache asyncChunkCache;
    private final CommandManager commands = new CommandManager();
    private Settings config;
    private boolean enabled;
    private LocationLookup locationLookup;
    private final NMSHelper nmsHelper = new NMSHelper(){
        private boolean SUPPORT_OWNER_PROFILE = false;
        {
            try {
                SkullMeta.class.getMethod("getOwnerProfile", new Class[0]);
                this.SUPPORT_OWNER_PROFILE = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public OfflinePlayer getPlayer(BlockCommandSender sender) {
            Entity entity = NMS.getSource(sender);
            return entity instanceof OfflinePlayer ? (OfflinePlayer)entity : null;
        }

        @Override
        public String getTexture(SkullMeta meta) {
            SkinProperty sp = SkinProperty.fromMojangProfile(NMS.getProfile(meta));
            return sp == null ? null : sp.value;
        }

        @Override
        public SpigotUtil.InventoryViewAPI openAnvilInventory(Player player, Inventory inventory, String title) {
            return new SpigotUtil.InventoryViewAPI(NMS.openAnvilInventory(player, inventory, title));
        }

        @Override
        public void setTexture(String texture, SkullMeta meta) {
            GameProfile profile = NMS.getProfile(meta);
            if (profile == null) {
                profile = this.SUPPORT_OWNER_PROFILE ? new GameProfile(meta.getOwnerProfile().getUniqueId(), meta.getOwnerProfile().getName()) : new GameProfile(UUID.randomUUID(), null);
            }
            NMS.setProfile(meta, new SkinProperty("textures", texture, null).applyProperties(profile));
        }

        @Override
        public void updateInventoryTitle(Player player, SpigotUtil.InventoryViewAPI view, String newTitle) {
            Inventory top = view.getTopInventory();
            if (top.getType() == InventoryType.CRAFTING || top.getType() == InventoryType.CREATIVE || top.getType() == InventoryType.PLAYER) {
                return;
            }
            NMS.updateInventoryTitle(player, view, newTitle);
        }
    };
    private CitizensNPCRegistry npcRegistry;
    private ProtocolLibListener protocolListener;
    private boolean saveOnDisable = true;
    private NPCDataStore saves;
    private NPCSelector selector;
    private StoredShops shops;
    private final Map<String, NPCRegistry> storedRegistries = Maps.newHashMap();
    private TemplateRegistry templateRegistry;
    private NPCRegistry temporaryRegistry;
    private CitizensTraitFactory traitFactory;

    @Override
    public NPCRegistry createAnonymousNPCRegistry(NPCDataStore store) {
        CitizensNPCRegistry anon = new CitizensNPCRegistry(store, "anonymous-" + UUID.randomUUID().toString());
        this.anonymousRegistries.add(anon);
        return anon;
    }

    @Override
    public NPCRegistry createNamedNPCRegistry(String name, NPCDataStore store) {
        CitizensNPCRegistry created = new CitizensNPCRegistry(store, name);
        this.storedRegistries.put(name, created);
        return created;
    }

    private NPCDataStore createStorage(File folder) {
        YamlStorage saves = new YamlStorage(new File(folder, Settings.Setting.STORAGE_FILE.asString()), "Citizens NPC Storage", Settings.Setting.EXPERIMENTAL_LIST_STORAGE.asBoolean());
        if (!saves.load()) {
            return null;
        }
        return SimpleNPCDataStore.create(saves);
    }

    private void despawnNPCs(boolean save) {
        for (NPCRegistry registry : Arrays.asList(this.npcRegistry, this.temporaryRegistry)) {
            if (registry == null) continue;
            if (save) {
                if (registry == this.npcRegistry) {
                    this.storeNPCsNow();
                } else {
                    registry.saveToStore();
                }
            }
            registry.despawnNPCs(DespawnReason.RELOAD);
        }
    }

    @Override
    public AsyncChunkCache getAsyncChunkCache() {
        if (this.asyncChunkCache == null) {
            this.asyncChunkCache = new AsyncChunkCache(this, Runtime.getRuntime().availableProcessors() > 12 ? 4 : 2, Settings.Setting.CITIZENS_PATHFINDER_ASYNC_CHUNK_CACHE_TTL.asDuration().toMillis());
        }
        return this.asyncChunkCache;
    }

    @Override
    public CommandManager getCommandManager() {
        return this.commands;
    }

    public NPCDataStore getDefaultNPCDataStore() {
        return this.saves;
    }

    @Override
    public NPCSelector getDefaultNPCSelector() {
        return this.selector;
    }

    @Override
    public LocationLookup getLocationLookup() {
        return this.locationLookup;
    }

    @Override
    public NPCRegistry getNamedNPCRegistry(String name) {
        if (name.equals(this.npcRegistry.getName())) {
            return this.npcRegistry;
        }
        return this.storedRegistries.get(name);
    }

    @Override
    public NMSHelper getNMSHelper() {
        return this.nmsHelper;
    }

    @Override
    public Iterable<NPCRegistry> getNPCRegistries() {
        return () -> new Iterator<NPCRegistry>(){
            Iterator<NPCRegistry> stored;

            @Override
            public boolean hasNext() {
                return this.stored == null ? true : this.stored.hasNext();
            }

            @Override
            public NPCRegistry next() {
                if (this.stored == null) {
                    this.stored = Iterables.concat(Citizens.this.storedRegistries.values(), (Iterable)Citizens.this.anonymousRegistries, Arrays.asList(Citizens.this.temporaryRegistry)).iterator();
                    return Citizens.this.npcRegistry;
                }
                return this.stored.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public NPCRegistry getNPCRegistry() {
        return this.npcRegistry;
    }

    public NPCSelector getNPCSelector() {
        return this.selector;
    }

    @Override
    public ClassLoader getOwningClassLoader() {
        return this.getClassLoader();
    }

    public ProtocolLibListener getProtocolLibListener() {
        return this.protocolListener;
    }

    public StoredShops getShops() {
        return this.shops;
    }

    @Override
    public TemplateRegistry getTemplateRegistry() {
        return this.templateRegistry;
    }

    @Override
    public NPCRegistry getTemporaryNPCRegistry() {
        return this.temporaryRegistry;
    }

    @Override
    public TraitFactory getTraitFactory() {
        return this.traitFactory;
    }

    private void loadAdventure() {
        BukkitLibraryManager lib = new BukkitLibraryManager(this);
        lib.addMavenCentral();
        lib.setLogLevel(LogLevel.INFO);
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-minimessage").version("4.25.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-api").version("4.25.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-key").version("4.25.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("examination-api").version("1.3.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("examination-string").version("1.3.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-platform-bukkit").version("4.4.1").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-platform-api").version("4.4.1").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-serializer-bungeecord").version("4.4.1").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-serializer-legacy").version("4.25.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-nbt").version("4.25.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-serializer-gson").version("4.25.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-serializer-json").version("4.25.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("option").version("1.1.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("org{}jspecify").artifactId("jspecify").version("1.0.0").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-serializer-commons").version("4.25.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-serializer-gson-legacy-impl").version("4.25.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-serializer-json-legacy-impl").version("4.25.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-platform-facet").version("4.4.1").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-platform-viaversion").version("4.4.1").relocate("net{}kyori", "clib{}net{}kyori").build());
    }

    public boolean onCommand(CommandSender sender, Command command, String cmdName, String[] args) {
        Object[] methodArgs = new Object[]{sender, this.selector == null ? null : this.selector.getSelected(sender)};
        return this.commands.executeSafe(command, args, sender, methodArgs);
    }

    public void onDependentPluginDisable() {
        if (this.enabled) {
            this.storeNPCsNow();
            this.saveOnDisable = false;
        }
    }

    public void onDisable() {
        if (!this.enabled) {
            return;
        }
        Editor.leaveAll();
        this.despawnNPCs(this.saveOnDisable);
        HandlerList.unregisterAll((Plugin)this);
        this.templateRegistry = null;
        this.npcRegistry = null;
        this.locationLookup = null;
        if (this.asyncChunkCache != null) {
            this.asyncChunkCache.shutdown();
            this.asyncChunkCache = null;
        }
        this.enabled = false;
        this.saveOnDisable = true;
        ProfileFetcher.shutdown();
        Skin.clearCache();
        NMS.shutdown();
        CitizensAPI.shutdown();
    }

    public void onEnable() {
        this.loadAdventure();
        PhTreeHelper.enablePooling((boolean)false);
        PhTreeHelper.ARRAY_POOLING_POOL_SIZE = 0;
        PhTreeHelper.ARRAY_POOLING_MAX_ARRAY_SIZE = 0;
        PhTreeHelper.MAX_OBJECT_POOL_SIZE = 0;
        CitizensAPI.setImplementation(this);
        this.config = new Settings(this.getDataFolder());
        this.setupTranslator();
        try {
            NMS.loadBridge();
        }
        catch (Exception e) {
            if (Messaging.isDebugging()) {
                e.printStackTrace();
            }
            Messaging.severeTr("citizens.notifications.incompatible-version", this.getDescription().getVersion());
            NMS.shutdown();
            CitizensAPI.shutdown();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.saves = this.createStorage(this.getDataFolder());
        this.shops = new StoredShops(new YamlStorage(new File(this.getDataFolder(), "shops.yml"), "Citizens NPC Shops", Settings.Setting.EXPERIMENTAL_LIST_STORAGE.asBoolean()));
        if (this.saves == null || !this.shops.loadFromDisk()) {
            Messaging.severeTr("citizens.saves.load-failed", new Object[0]);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.npcRegistry = new CitizensNPCRegistry(this.saves, "citizens");
        this.temporaryRegistry = new CitizensNPCRegistry(new MemoryNPCDataStore(), "citizens-temporary");
        this.locationLookup = new LocationLookup(this.npcRegistry);
        this.locationLookup.runTaskTimer(CitizensAPI.getPlugin(), 0L, 5L);
        this.traitFactory = new CitizensTraitFactory(this);
        this.selector = new NPCSelector(this);
        this.saveResource("templates/citizens/templates.yml", true);
        this.templateRegistry = new TemplateRegistry(new File(this.getDataFolder(), "templates").toPath());
        if (!new File(this.getDataFolder(), "skins").exists()) {
            new File(this.getDataFolder(), "skins").mkdir();
        }
        Bukkit.getPluginManager().registerEvents((Listener)new EventListen(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Placeholders(), (Plugin)this);
        Plugin papi = Bukkit.getPluginManager().getPlugin("PlaceholderAPI");
        if (papi != null && papi.isEnabled()) {
            new CitizensPlaceholders(this.selector).register();
        }
        this.setupEconomy();
        this.registerCommands();
        NMS.load(this.commands);
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.commands.registerTabCompletion(this);
        this.commands.setTranslationPrefixProvider(cmd -> "citizens.commands." + cmd.aliases()[0] + (cmd.modifiers().length > 0 && !cmd.modifiers()[0].isEmpty() ? "." + cmd.modifiers()[0] : ""));
        if (this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, (Runnable)new CitizensLoadTask(), 1L) == -1) {
            Messaging.severeTr("citizens.load-task-error", new Object[0]);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    @Override
    public void onImplementationChanged() {
        Messaging.severeTr("citizens.changed-implementation", new Object[0]);
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    public void registerCommandClass(Class<?> clazz) {
        try {
            this.commands.register(clazz);
        }
        catch (Throwable ex) {
            Messaging.logTr("citizens.commands.invalid.class", new Object[0]);
            ex.printStackTrace();
        }
    }

    private void registerCommands() {
        this.commands.setInjector(new Injector(this));
        this.commands.register(AdminCommands.class);
        this.commands.register(EditorCommands.class);
        this.commands.register(NPCCommands.class);
        this.commands.register(TemplateCommands.class);
        this.commands.register(TraitCommands.class);
        this.commands.register(WaypointCommands.class);
    }

    public void reload() throws NPCLoadException {
        this.getServer().getPluginManager().callEvent((Event)new CitizensPreReloadEvent());
        Editor.leaveAll();
        this.config.reload();
        this.despawnNPCs(false);
        ProfileFetcher.reset();
        Skin.clearCache();
        this.templateRegistry = new TemplateRegistry(new File(this.getDataFolder(), "templates").toPath());
        this.saves.reloadFromSource();
        this.saves.loadInto(this.npcRegistry);
        this.shops.loadFromDisk();
        this.shops.load();
        this.getServer().getPluginManager().callEvent((Event)new CitizensReloadEvent());
    }

    @Override
    public void removeNamedNPCRegistry(String name) {
        this.storedRegistries.remove(name);
    }

    private void scheduleSaveTask(int delay) {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new CitizensSaveTask(), (long)delay, (long)delay);
    }

    @Override
    public void setDefaultNPCDataStore(NPCDataStore store) {
        if (store == null) {
            throw new IllegalArgumentException("must be non-null");
        }
        this.despawnNPCs(true);
        this.saves = store;
        this.npcRegistry = new CitizensNPCRegistry(this.saves, "citizens-global-" + UUID.randomUUID().toString());
        this.saves.loadInto(this.npcRegistry);
    }

    private void setupEconomy() {
        try {
            RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(Economy.class);
            if (provider != null && provider.getProvider() != null) {
                Economy economy = (Economy)provider.getProvider();
                Bukkit.getPluginManager().registerEvents((Listener)new PaymentListener(economy), (Plugin)this);
            }
            Messaging.logTr("citizens.economy.loaded", new Object[0]);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private void setupTranslator() {
        Locale locale = Locale.getDefault();
        String setting = Settings.Setting.LOCALE.asString();
        if (!setting.isEmpty()) {
            String[] parts = setting.split("[\\._]");
            switch (parts.length) {
                case 1: {
                    locale = new Locale(parts[0]);
                    break;
                }
                case 2: {
                    locale = new Locale(parts[0], parts[1]);
                    break;
                }
                case 3: {
                    locale = new Locale(parts[0], parts[1], parts[2]);
                    break;
                }
            }
        }
        Translator.setInstance(new File(this.getDataFolder(), "lang"), locale);
        if (!locale.getLanguage().equals("en")) {
            Messaging.logTr("citizens.contribute-to-translations-prompt", locale.getLanguage());
        }
    }

    private void startMetrics() {
        try {
            Metrics metrics = new Metrics(this, 2463);
            metrics.addCustomChart(new Metrics.SingleLineChart("total_npcs", () -> this.npcRegistry == null ? 0 : Iterables.size((Iterable)this.npcRegistry)));
            metrics.addCustomChart(new Metrics.SingleLineChart("total_templates", () -> this.npcRegistry == null ? 0 : (int)this.templateRegistry.getAllTemplates().stream().filter(t -> !t.getKey().getNamespace().equals("citizens")).count()));
            metrics.addCustomChart(new Metrics.SimplePie("locale", () -> Locale.getDefault().getLanguage()));
            metrics.addCustomChart(new Metrics.AdvancedPie("traits", () -> {
                HashMap res = Maps.newHashMap();
                for (NPC npc : this.npcRegistry) {
                    for (Trait trait : npc.getTraits()) {
                        if (!this.traitFactory.trackStats(trait)) continue;
                        res.put(trait.getName(), res.getOrDefault(trait.getName(), 0) + 1);
                    }
                }
                return res;
            }));
        }
        catch (Exception e) {
            Messaging.logTr("citizens.notifications.metrics-load-error", e.getMessage());
        }
    }

    public void storeNPCs() {
        if (this.saves == null) {
            return;
        }
        this.saves.storeAll(this.npcRegistry);
        this.shops.storeShops();
        this.shops.saveToDisk();
        this.saves.saveToDisk();
    }

    public void storeNPCsNow() {
        if (this.saves == null) {
            return;
        }
        this.saves.storeAll(this.npcRegistry);
        this.shops.storeShops();
        this.shops.saveToDiskImmediate();
        this.saves.saveToDiskImmediate();
    }

    @Override
    public void talk(SpeechContext context) {
        Util.talk(context);
    }

    private class CitizensLoadTask
    implements Runnable {
        private CitizensLoadTask() {
        }

        @Override
        public void run() {
            Plugin plib = Bukkit.getPluginManager().getPlugin("ProtocolLib");
            if (Settings.Setting.HOOK_PROTOCOLLIB.asBoolean() && plib != null && plib.isEnabled() && ProtocolLibrary.getProtocolManager() != null) {
                try {
                    Citizens.this.protocolListener = new ProtocolLibListener(Citizens.this);
                }
                catch (Throwable t) {
                    Messaging.severe("ProtocolLib support not enabled due to following error:");
                    t.printStackTrace();
                }
            }
            Citizens.this.saves.loadInto(Citizens.this.npcRegistry);
            Citizens.this.shops.load();
            Messaging.logTr("citizens.notifications.npcs-loaded", Iterables.size((Iterable)Citizens.this.npcRegistry), "?");
            Citizens.this.startMetrics();
            Citizens.this.scheduleSaveTask(Settings.Setting.SAVE_TASK_FREQUENCY.asTicks());
            Bukkit.getPluginManager().callEvent((Event)new CitizensEnableEvent());
            new PlayerUpdateTask().runTaskTimer(Citizens.this, 0L, 1L);
            Citizens.this.enabled = true;
        }
    }

    private class CitizensSaveTask
    implements Runnable {
        private CitizensSaveTask() {
        }

        @Override
        public void run() {
            Citizens.this.storeNPCs();
        }
    }
}

