/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import org.bukkit.DyeColor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Wolf;

@TraitName(value="wolfmodifiers")
public class WolfModifiers
extends Trait {
    @Persist
    private boolean angry;
    @Persist(value="collarColor")
    private DyeColor collarColor = DyeColor.RED;
    @Persist
    private boolean interested;
    @Persist
    private boolean sitting;
    @Persist
    private boolean tamed;
    @Persist
    private String variant;
    private static boolean SUPPORT_SET_INTERESTED = true;
    private static final Map<String, Object> VARIANT_CACHE = new HashMap<String, Object>();

    public WolfModifiers() {
        super("wolfmodifiers");
    }

    public DyeColor getCollarColor() {
        return this.collarColor;
    }

    public String getVariant() {
        return this.variant;
    }

    public boolean isAngry() {
        return this.angry;
    }

    public boolean isInterested() {
        return this.interested;
    }

    public boolean isSitting() {
        return this.sitting;
    }

    public boolean isTamed() {
        return this.tamed;
    }

    @Override
    public void onSpawn() {
        this.updateModifiers();
    }

    public void setAngry(boolean angry) {
        this.angry = angry;
        this.updateModifiers();
    }

    public void setCollarColor(DyeColor color) {
        this.collarColor = color;
        this.updateModifiers();
    }

    public void setInterested(boolean interested) {
        this.interested = interested;
        this.updateModifiers();
    }

    public void setSitting(boolean sitting) {
        this.sitting = sitting;
        this.updateModifiers();
    }

    public void setTamed(boolean tamed) {
        this.tamed = tamed;
        this.updateModifiers();
    }

    public void setVariant(String variant) {
        this.variant = variant;
        this.updateModifiers();
    }

    private void updateModifiers() {
        if (this.npc.getCosmeticEntity() instanceof Wolf) {
            Wolf wolf = (Wolf)this.npc.getCosmeticEntity();
            wolf.setCollarColor(this.collarColor);
            wolf.setSitting(this.sitting);
            wolf.setAngry(this.angry);
            if (this.angry) {
                wolf.setTarget((LivingEntity)wolf);
            }
            if (this.variant != null) {
                wolf.setVariant((Wolf.Variant)VARIANT_CACHE.computeIfAbsent(this.variant, v -> {
                    try {
                        return Wolf.Variant.class.getField(this.variant).get(null);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        return null;
                    }
                }));
            }
            wolf.setTamed(this.tamed);
            if (SUPPORT_SET_INTERESTED) {
                wolf.setInterested(this.interested);
            }
        }
    }

    static {
        try {
            Wolf.class.getMethod("setInterested", Boolean.TYPE);
        }
        catch (Throwable e) {
            SUPPORT_SET_INTERESTED = false;
        }
    }
}

