/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.DyeColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Shulker;

@TraitName(value="shulkertrait")
public class ShulkerTrait
extends Trait {
    @Persist(value="color")
    private DyeColor color = DyeColor.PURPLE;
    private int lastPeekSet = 0;
    @Persist(value="peek")
    private int peek = 0;

    public ShulkerTrait() {
        super("shulkertrait");
    }

    public DyeColor getColor() {
        return this.color;
    }

    public int getPeek() {
        return this.peek;
    }

    @Override
    public void onSpawn() {
        this.setPeek(this.peek);
    }

    @Override
    public void run() {
        if (this.color == null) {
            this.color = DyeColor.PURPLE;
        }
        if (this.npc.getCosmeticEntity() instanceof Shulker) {
            if (this.peek != this.lastPeekSet) {
                NMS.setPeekShulker(this.npc.getCosmeticEntity(), this.peek);
                this.lastPeekSet = this.peek;
            }
            ((Shulker)this.npc.getCosmeticEntity()).setColor(this.color);
        }
    }

    public void setColor(DyeColor color) {
        this.color = color;
    }

    public void setPeek(int peek) {
        this.peek = peek;
        this.lastPeekSet = -1;
    }

    @Command(aliases={"npc"}, usage="shulker (--peek [peek] --color [color])", desc="", modifiers={"shulker"}, min=1, max=1, permission="citizens.npc.shulker")
    @Requirements(selected=true, ownership=true, cosmeticTypes={EntityType.SHULKER})
    public static void shulker(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"peek"}) Integer peek, @Flag(value={"color"}) DyeColor color) throws CommandException {
        ShulkerTrait trait = npc.getOrAddTrait(ShulkerTrait.class);
        boolean hasArg = false;
        if (peek != null) {
            trait.setPeek((byte)peek.intValue());
            Messaging.sendTr(sender, "citizens.commands.npc.shulker.peek-set", npc.getName(), peek);
            hasArg = true;
        }
        if (args.hasValueFlag("color")) {
            if (color == null) {
                Messaging.sendErrorTr(sender, "citizens.commands.npc.shulker.invalid-color", Util.listValuesPretty(DyeColor.values()));
                return;
            }
            trait.setColor(color);
            Messaging.sendTr(sender, "citizens.commands.npc.shulker.color-set", npc.getName(), Util.prettyEnum(color));
            hasArg = true;
        }
        if (!hasArg) {
            throw new CommandUsageException();
        }
    }
}

