/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import java.util.function.Consumer;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.expr.CompiledExpression;
import net.citizensnpcs.api.expr.ExpressionEngine;
import net.citizensnpcs.api.expr.ExpressionScope;
import net.citizensnpcs.api.gui.InputMenus;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.trait.ShopTrait;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.util.InventoryMultiplexer;
import net.citizensnpcs.util.Util;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ConditionAction
extends NPCShopAction {
    @Persist
    private String condition;
    private CompiledExpression expression;

    public ConditionAction() {
    }

    public ConditionAction(String expression) {
        this.condition = expression;
    }

    private void compile() {
        try {
            this.expression = CitizensAPI.getExpressionRegistry().compile(this.condition);
        }
        catch (ExpressionEngine.ExpressionCompileException e) {
            e.printStackTrace();
        }
    }

    private ExpressionScope createTransactionScope(Player player) {
        ExpressionScope scope = new ExpressionScope();
        scope.setPlayer(player);
        return scope;
    }

    @Override
    public String describe() {
        return this.condition;
    }

    @Override
    public int getMaxRepeats(Entity entity, InventoryMultiplexer inventory) {
        return -1;
    }

    @Override
    public NPCShopAction.Transaction grant(ShopTrait.NPCShopStorage storage, Entity entity, InventoryMultiplexer inventory, int repeats) {
        if (this.condition == null) {
            return NPCShopAction.Transaction.success();
        }
        if (this.expression == null) {
            this.compile();
        }
        ExpressionScope scope = this.createTransactionScope(entity instanceof Player ? (Player)entity : null);
        return NPCShopAction.Transaction.create(() -> this.expression.evaluateAsBoolean(scope), () -> {}, () -> {});
    }

    public void setExpression(String expression) {
        this.condition = CitizensAPI.getExpressionRegistry().applyDefaultExpressionMarkup(expression);
        this.expression = null;
    }

    @Override
    public NPCShopAction.Transaction take(ShopTrait.NPCShopStorage storage, Entity entity, InventoryMultiplexer inventory, int repeats) {
        if (this.condition == null) {
            return NPCShopAction.Transaction.success();
        }
        if (this.expression == null) {
            this.compile();
        }
        ExpressionScope scope = this.createTransactionScope(entity instanceof Player ? (Player)entity : null);
        return NPCShopAction.Transaction.create(() -> this.expression.evaluateAsBoolean(scope), () -> {}, () -> {});
    }

    public static class ConditionActionGUI
    implements NPCShopAction.GUI {
        @Override
        public boolean canUse(HumanEntity entity) {
            return entity.hasPermission("citizens.npc.shop.editor.actions.edit-condition");
        }

        @Override
        public InventoryMenuPage createEditor(NPCShopAction previous, Consumer<NPCShopAction> callback) {
            ConditionAction action = previous == null ? new ConditionAction() : (ConditionAction)previous;
            return InputMenus.stringSetter("Condition", () -> action.condition, s -> {
                action.setExpression((String)s);
                callback.accept(action);
            });
        }

        @Override
        public ItemStack createMenuItem(NPCShopAction previous) {
            String description = null;
            if (previous != null) {
                ConditionAction old = (ConditionAction)previous;
                description = old.describe();
            }
            return Util.createItem(Material.ENCHANTED_BOOK, "Condition", description);
        }

        @Override
        public boolean manages(NPCShopAction action) {
            return action instanceof ConditionAction;
        }
    }
}

