/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.hpastar;

import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Consumer;
import net.citizensnpcs.api.hpastar.HPAEntrance;
import net.citizensnpcs.api.hpastar.HPAGraph;
import net.citizensnpcs.api.hpastar.HPAGraphEdge;
import net.citizensnpcs.api.hpastar.HPAGraphNode;

public class HPACluster {
    final int clusterHeight;
    final int clusterSize;
    final int clusterX;
    final int clusterY;
    final int clusterZ;
    private final HPAGraph graph;
    private final int level;
    private final List<HPAGraphNode> nodes = new ArrayList<HPAGraphNode>();
    private final Long2ObjectOpenHashMap<HPAGraphNode> nodesByPosition = new Long2ObjectOpenHashMap();
    private final byte[] walkableCache;
    private static final float[] NEIGHBOUR_COSTS;
    private static final int[][] NEIGHBOUR_OFFSETS;

    public HPACluster(HPAGraph graph, int level, int clusterSize, int clusterHeight, int clusterX, int clusterY, int clusterZ) {
        this.graph = graph;
        this.level = level;
        this.clusterSize = clusterSize;
        this.clusterHeight = clusterHeight;
        this.clusterX = clusterX;
        this.clusterY = clusterY;
        this.clusterZ = clusterZ;
        this.walkableCache = new byte[clusterSize * clusterHeight * clusterSize];
        Arrays.fill(this.walkableCache, (byte)-1);
    }

    private HPAGraphNode[] addEntranceNode(HPAEntrance entrance) {
        if (entrance.minY == entrance.maxY) {
            if (entrance.maxX - entrance.minX > 6) {
                return new HPAGraphNode[]{this.getOrAddNode(entrance.minX, entrance.minY, entrance.minZ), this.getOrAddNode(entrance.maxX, entrance.minY, entrance.minZ)};
            }
            if (entrance.maxZ - entrance.minZ > 6) {
                return new HPAGraphNode[]{this.getOrAddNode(entrance.minX, entrance.minY, entrance.minZ), this.getOrAddNode(entrance.minX, entrance.minY, entrance.maxZ)};
            }
            int x = (int)(entrance.minX == entrance.maxX ? (double)entrance.minX : Math.floor((double)(entrance.minX + entrance.maxX) / 2.0));
            int z = (int)(entrance.minZ == entrance.maxZ ? (double)entrance.minZ : Math.floor((double)(entrance.minZ + entrance.maxZ) / 2.0));
            return new HPAGraphNode[]{this.getOrAddNode(x, entrance.minY, z)};
        }
        int x = (int)Math.floor((double)(entrance.minX + entrance.maxX) / 2.0);
        int y = (int)Math.floor((double)(entrance.minY + entrance.maxY) / 2.0);
        int z = (int)Math.floor((double)(entrance.minZ + entrance.maxZ) / 2.0);
        return new HPAGraphNode[]{this.getOrAddNode(x, y, z)};
    }

    private void addNodeReference(HPAGraphNode node) {
        long key = HPACluster.packPosition(node.x, node.y, node.z);
        HPAGraphNode old = (HPAGraphNode)this.nodesByPosition.put(key, (Object)node);
        if (old != null) {
            throw new IllegalStateException();
        }
        this.nodes.add(node);
    }

    public void buildFrom(List<HPACluster> clusters) {
        for (HPACluster other : clusters) {
            for (HPAGraphNode node : other.nodes) {
                if (node.x != this.clusterX && node.z != this.clusterZ && node.y != this.clusterY && node.x != this.clusterX + this.clusterSize - 1 && node.z != this.clusterZ + this.clusterSize - 1 && node.y != this.clusterY + this.clusterHeight - 1) continue;
                this.addNodeReference(node);
                for (HPAGraphEdge edge : node.getEdges(this.level - 1)) {
                    if (edge.type != HPAGraphEdge.EdgeType.INTER) continue;
                    edge.from.connect(this.level, edge.to, edge.type, edge.weight);
                }
            }
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            HPAGraphNode source = this.nodes.get(i);
            Long2ObjectOpenHashMap unresolvedTargets = new Long2ObjectOpenHashMap();
            for (int j = i + 1; j < this.nodes.size(); ++j) {
                HPAGraphNode target = this.nodes.get(j);
                HPAGraphNode old = (HPAGraphNode)unresolvedTargets.put(HPACluster.packPosition(target.x, target.y, target.z), (Object)target);
                if (old == null) continue;
                throw new IllegalStateException();
            }
            if (unresolvedTargets.isEmpty()) continue;
            this.connectLowerLevelFromSource(source, (Long2ObjectOpenHashMap<HPAGraphNode>)unresolvedTargets);
        }
    }

    public void connect(HPACluster other, Direction direction) {
        HPAEntrance entrance = null;
        switch (direction.ordinal()) {
            case 1: {
                for (int y = 0; y < this.clusterHeight; ++y) {
                    for (int z = 0; z < this.clusterSize; ++z) {
                        if (this.offsetWalkable(this.clusterSize - 1, y, z) && other.offsetWalkable(0, y, z)) {
                            if (entrance == null) {
                                entrance = new HPAEntrance();
                                entrance.minY = entrance.maxY = y;
                                entrance.minX = entrance.maxX = this.clusterSize - 1;
                                entrance.minZ = z;
                            }
                            entrance.maxZ = z;
                            continue;
                        }
                        if (entrance == null) continue;
                        this.connectEntrance(other, entrance, e -> {
                            e.maxX = 0;
                            e.minX = 0;
                        });
                        entrance = null;
                    }
                    if (entrance == null) continue;
                    this.connectEntrance(other, entrance, e -> {
                        e.maxX = 0;
                        e.minX = 0;
                    });
                    entrance = null;
                }
                break;
            }
            case 5: {
                for (int y = 0; y < this.clusterHeight; ++y) {
                    for (int z = 0; z < this.clusterSize; ++z) {
                        if (this.offsetWalkable(0, y, z) && other.offsetWalkable(this.clusterSize - 1, y, z)) {
                            if (entrance == null) {
                                entrance = new HPAEntrance();
                                entrance.minY = entrance.maxY = y;
                                entrance.maxX = 0;
                                entrance.minX = 0;
                                entrance.minZ = z;
                            }
                            entrance.maxZ = z;
                            continue;
                        }
                        if (entrance == null) continue;
                        this.connectEntrance(other, entrance, e -> {
                            e.minX = e.maxX = this.clusterSize - 1;
                        });
                        entrance = null;
                    }
                    if (entrance == null) continue;
                    this.connectEntrance(other, entrance, e -> {
                        e.minX = e.maxX = this.clusterSize - 1;
                    });
                    entrance = null;
                }
                break;
            }
            case 2: {
                for (int y = 0; y < this.clusterHeight; ++y) {
                    for (int x = 0; x < this.clusterSize; ++x) {
                        if (this.offsetWalkable(x, y, this.clusterSize - 1) && other.offsetWalkable(x, y, 0)) {
                            if (entrance == null) {
                                entrance = new HPAEntrance();
                                entrance.minY = entrance.maxY = y;
                                entrance.minZ = entrance.maxZ = this.clusterSize - 1;
                                entrance.minX = x;
                            }
                            entrance.maxX = x;
                            continue;
                        }
                        if (entrance == null) continue;
                        this.connectEntrance(other, entrance, e -> {
                            e.maxZ = 0;
                            e.minZ = 0;
                        });
                        entrance = null;
                    }
                    if (entrance == null) continue;
                    this.connectEntrance(other, entrance, e -> {
                        e.maxZ = 0;
                        e.minZ = 0;
                    });
                    entrance = null;
                }
                break;
            }
            case 3: {
                for (int y = 0; y < this.clusterHeight; ++y) {
                    for (int x = 0; x < this.clusterSize; ++x) {
                        if (this.offsetWalkable(x, y, 0) && other.offsetWalkable(x, y, this.clusterSize - 1)) {
                            if (entrance == null) {
                                entrance = new HPAEntrance();
                                entrance.minY = entrance.maxY = y;
                                entrance.maxZ = 0;
                                entrance.minZ = 0;
                                entrance.minX = x;
                            }
                            entrance.maxX = x;
                            continue;
                        }
                        if (entrance == null) continue;
                        this.connectEntrance(other, entrance, e -> {
                            e.minZ = e.maxZ = this.clusterSize - 1;
                        });
                        entrance = null;
                    }
                    if (entrance == null) continue;
                    this.connectEntrance(other, entrance, e -> {
                        e.minZ = e.maxZ = this.clusterSize - 1;
                    });
                    entrance = null;
                }
                break;
            }
            case 4: {
                for (int x = 0; x < this.clusterSize; ++x) {
                    for (int z = 0; z < this.clusterSize; ++z) {
                        if (this.offsetWalkable(x, this.clusterHeight - 1, z) && other.offsetWalkable(x, 0, z)) {
                            if (entrance == null) {
                                entrance = new HPAEntrance();
                                entrance.minY = entrance.maxY = this.clusterHeight - 1;
                                entrance.minX = x;
                                entrance.minZ = z;
                            }
                            entrance.maxX = x;
                            entrance.maxZ = z;
                            continue;
                        }
                        if (entrance == null) continue;
                        this.connectEntrance(other, entrance, e -> {
                            e.maxY = 0;
                            e.minY = 0;
                        });
                        entrance = null;
                    }
                }
                if (entrance == null) break;
                this.connectEntrance(other, entrance, e -> {
                    e.maxY = 0;
                    e.minY = 0;
                });
                break;
            }
            case 0: {
                for (int x = 0; x < this.clusterSize; ++x) {
                    for (int z = 0; z < this.clusterSize; ++z) {
                        if (this.offsetWalkable(x, 0, z) && other.offsetWalkable(x, this.clusterHeight - 1, z)) {
                            if (entrance == null) {
                                entrance = new HPAEntrance();
                                entrance.maxY = 0;
                                entrance.minY = 0;
                                entrance.minX = x;
                                entrance.minZ = z;
                            }
                            entrance.maxX = x;
                            entrance.maxZ = z;
                            continue;
                        }
                        if (entrance == null) continue;
                        this.connectEntrance(other, entrance, e -> {
                            e.minY = e.maxY = this.clusterHeight - 1;
                        });
                        entrance = null;
                    }
                }
                if (entrance == null) break;
                this.connectEntrance(other, entrance, e -> {
                    e.minY = e.maxY = this.clusterHeight - 1;
                });
            }
        }
    }

    public void connectDiagonal(HPACluster other, int dx, int dz, float weight) {
        int fromX = dx > 0 ? this.clusterSize - 1 : 0;
        int fromZ = dz > 0 ? this.clusterSize - 1 : 0;
        int toX = dx > 0 ? 0 : other.clusterSize - 1;
        int toZ = dz > 0 ? 0 : other.clusterSize - 1;
        for (int y = 0; y < this.clusterHeight; ++y) {
            if (!this.offsetWalkable(fromX, y, fromZ) || !other.offsetWalkable(toX, y, toZ)) continue;
            HPAGraphNode from = this.getOrAddNode(fromX, y, fromZ);
            HPAGraphNode to = other.getOrAddNode(toX, y, toZ);
            from.connect(this.level, to, HPAGraphEdge.EdgeType.INTER, weight);
        }
    }

    private void connectEntrance(HPACluster other, HPAEntrance entrance, Consumer<HPAEntrance> consumer) {
        HPAGraphNode[] from = this.addEntranceNode(entrance);
        consumer.accept(entrance);
        HPAGraphNode[] to = other.addEntranceNode(entrance);
        for (int i = 0; i < from.length; ++i) {
            from[i].connect(this.level, to[i], HPAGraphEdge.EdgeType.INTER, 1.0f);
        }
    }

    public void connectIntra() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            HPAGraphNode source = this.nodes.get(i);
            Long2ObjectOpenHashMap unresolvedTargets = new Long2ObjectOpenHashMap();
            for (int j = i + 1; j < this.nodes.size(); ++j) {
                HPAGraphNode target = this.nodes.get(j);
                HPAGraphNode old = (HPAGraphNode)unresolvedTargets.put(HPACluster.packPosition(target.x, target.y, target.z), (Object)target);
                if (old == null) continue;
                throw new IllegalStateException();
            }
            if (unresolvedTargets.isEmpty()) continue;
            this.connectIntraFromSource(source, (Long2ObjectOpenHashMap<HPAGraphNode>)unresolvedTargets);
        }
    }

    private void connectIntraFromSource(HPAGraphNode source, Long2ObjectOpenHashMap<HPAGraphNode> unresolvedTargets) {
        Long2FloatOpenHashMap bestCosts = new Long2FloatOpenHashMap();
        bestCosts.defaultReturnValue(Float.POSITIVE_INFINITY);
        PriorityQueue<IntraFrontierNode> frontier = new PriorityQueue<IntraFrontierNode>();
        long sourceKey = HPACluster.packPosition(source.x, source.y, source.z);
        bestCosts.put(sourceKey, 0.0f);
        frontier.add(new IntraFrontierNode(source.x, source.y, source.z, 0.0f));
        while (!frontier.isEmpty() && !unresolvedTargets.isEmpty()) {
            IntraFrontierNode current = (IntraFrontierNode)frontier.poll();
            long currentKey = HPACluster.packPosition(current.x, current.y, current.z);
            if (current.g > bestCosts.get(currentKey)) continue;
            HPAGraphNode reached = (HPAGraphNode)unresolvedTargets.remove(currentKey);
            if (reached != null) {
                source.connect(this.level, reached, HPAGraphEdge.EdgeType.INTRA, current.g);
                if (unresolvedTargets.isEmpty()) break;
            }
            for (int i = 0; i < NEIGHBOUR_OFFSETS.length; ++i) {
                long neighbourKey;
                float tentativeCost;
                int nx = current.x + NEIGHBOUR_OFFSETS[i][0];
                int ny = current.y + NEIGHBOUR_OFFSETS[i][1];
                int nz = current.z + NEIGHBOUR_OFFSETS[i][2];
                if (nx < this.clusterX || nx >= this.clusterX + this.clusterSize || ny < this.clusterY || ny >= this.clusterY + this.clusterHeight || nz < this.clusterZ || nz >= this.clusterZ + this.clusterSize || !this.offsetWalkable(nx - this.clusterX, ny - this.clusterY, nz - this.clusterZ) || (tentativeCost = current.g + NEIGHBOUR_COSTS[i]) >= bestCosts.get(neighbourKey = HPACluster.packPosition(nx, ny, nz))) continue;
                bestCosts.put(neighbourKey, tentativeCost);
                frontier.add(new IntraFrontierNode(nx, ny, nz, tentativeCost));
            }
        }
    }

    private void connectLowerLevelFromSource(HPAGraphNode source, Long2ObjectOpenHashMap<HPAGraphNode> unresolvedTargets) {
        Long2FloatOpenHashMap bestCosts = new Long2FloatOpenHashMap();
        bestCosts.defaultReturnValue(Float.POSITIVE_INFINITY);
        PriorityQueue<GraphFrontierNode> frontier = new PriorityQueue<GraphFrontierNode>();
        long sourceKey = HPACluster.packPosition(source.x, source.y, source.z);
        bestCosts.put(sourceKey, 0.0f);
        frontier.add(new GraphFrontierNode(source, 0.0f));
        while (!frontier.isEmpty() && !unresolvedTargets.isEmpty()) {
            GraphFrontierNode current = (GraphFrontierNode)frontier.poll();
            long currentKey = HPACluster.packPosition(current.node.x, current.node.y, current.node.z);
            if (current.g > bestCosts.get(currentKey)) continue;
            HPAGraphNode reached = (HPAGraphNode)unresolvedTargets.remove(currentKey);
            if (reached != null) {
                source.connect(this.level, reached, HPAGraphEdge.EdgeType.INTRA, current.g);
                if (unresolvedTargets.isEmpty()) break;
            }
            for (HPAGraphEdge edge : current.node.getEdges(this.level - 1)) {
                float tentativeCost = current.g + edge.weight;
                long neighbourKey = HPACluster.packPosition(edge.to.x, edge.to.y, edge.to.z);
                if (tentativeCost >= bestCosts.get(neighbourKey)) continue;
                bestCosts.put(neighbourKey, tentativeCost);
                frontier.add(new GraphFrontierNode(edge.to, tentativeCost));
            }
        }
    }

    public boolean contains(HPACluster other) {
        return this.clusterX + this.clusterSize > other.clusterX && this.clusterY + this.clusterHeight > other.clusterY && this.clusterZ + this.clusterSize > other.clusterZ && other.clusterX >= this.clusterX && other.clusterY >= this.clusterY && other.clusterZ >= this.clusterZ;
    }

    public boolean containsPoint(int x, int y, int z) {
        return x >= this.clusterX && x < this.clusterX + this.clusterSize && y >= this.clusterY && y < this.clusterY + this.clusterHeight && z >= this.clusterZ && z < this.clusterZ + this.clusterSize;
    }

    private HPAGraphNode getOrAddNode(int x, int y, int z) {
        long key = HPACluster.packPosition(this.clusterX + x, this.clusterY + y, this.clusterZ + z);
        HPAGraphNode existing = (HPAGraphNode)this.nodesByPosition.get(key);
        if (existing != null) {
            return existing;
        }
        HPAGraphNode node = new HPAGraphNode(this.clusterX + x, this.clusterY + y, this.clusterZ + z);
        this.addNodeReference(node);
        return node;
    }

    public boolean hasWalkableNodes() {
        for (int x = 0; x < this.clusterSize; ++x) {
            for (int y = 0; y < this.clusterHeight; ++y) {
                for (int z = 0; z < this.clusterSize; ++z) {
                    if (!this.offsetWalkable(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void insert(HPAGraphNode node) {
        this.addNodeReference(node);
        Long2ObjectOpenHashMap unresolvedTargets = new Long2ObjectOpenHashMap();
        for (HPAGraphNode target : this.nodes) {
            HPAGraphNode old;
            if (target == node || (old = (HPAGraphNode)unresolvedTargets.put(HPACluster.packPosition(target.x, target.y, target.z), (Object)target)) == null) continue;
            throw new IllegalStateException();
        }
        if (!unresolvedTargets.isEmpty()) {
            this.connectIntraFromSource(node, (Long2ObjectOpenHashMap<HPAGraphNode>)unresolvedTargets);
        }
    }

    private boolean offsetWalkable(int x, int y, int z) {
        int index = (y * this.clusterSize + z) * this.clusterSize + x;
        byte cached = this.walkableCache[index];
        if (cached == -1) {
            this.walkableCache[index] = cached = (byte)(this.graph.walkable(this.clusterX + x, this.clusterY + y, this.clusterZ + z) ? 1 : 0);
        }
        return cached == 1;
    }

    public void remove(HPAGraphNode ... nodes) {
        for (HPAGraphNode node : nodes) {
            List<List<HPAGraphEdge>> edges2 = node.edges;
            for (int i = 0; i < edges2.size(); ++i) {
                List<HPAGraphEdge> edges = edges2.get(i);
                for (HPAGraphEdge edge : edges) {
                    if (i >= edge.to.edges.size()) continue;
                    edge.to.edges.get(i).removeIf(other -> other.to == node);
                }
                edges.clear();
            }
            this.removeNodeReference(node);
        }
    }

    private void removeNodeReference(HPAGraphNode node) {
        this.nodes.remove(node);
        this.nodesByPosition.remove(HPACluster.packPosition(node.x, node.y, node.z));
    }

    public String toString() {
        return "C[" + this.level + "] (" + this.clusterX + "," + this.clusterY + "," + this.clusterZ + ")->(" + (this.clusterX + this.clusterSize - 1) + "," + (this.clusterY + this.clusterHeight - 1) + "," + (this.clusterZ + this.clusterSize - 1) + ")";
    }

    private static long packPosition(int x, int y, int z) {
        return ((long)x & 0x3FFFFFFL) << 34 | ((long)z & 0x3FFFFFFL) << 8 | (long)y & 0xFFL;
    }

    static {
        int[][] neighbours = new int[26][3];
        int index = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    neighbours[index][0] = dx;
                    neighbours[index][1] = dy;
                    neighbours[index][2] = dz;
                    ++index;
                }
            }
        }
        NEIGHBOUR_OFFSETS = neighbours;
        float[] costs = new float[NEIGHBOUR_OFFSETS.length];
        for (int i = 0; i < NEIGHBOUR_OFFSETS.length; ++i) {
            int dx = NEIGHBOUR_OFFSETS[i][0];
            int dy = NEIGHBOUR_OFFSETS[i][1];
            int dz = NEIGHBOUR_OFFSETS[i][2];
            costs[i] = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        }
        NEIGHBOUR_COSTS = costs;
    }

    public static enum Direction {
        DOWN,
        EAST,
        NORTH,
        SOUTH,
        UP,
        WEST;

    }

    private static class IntraFrontierNode
    implements Comparable<IntraFrontierNode> {
        final float g;
        final int x;
        final int y;
        final int z;

        private IntraFrontierNode(int x, int y, int z, float g) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.g = g;
        }

        @Override
        public int compareTo(IntraFrontierNode other) {
            return Float.compare(this.g, other.g);
        }
    }

    private static class GraphFrontierNode
    implements Comparable<GraphFrontierNode> {
        final float g;
        final HPAGraphNode node;

        private GraphFrontierNode(HPAGraphNode node, float g) {
            this.node = node;
            this.g = g;
        }

        @Override
        public int compareTo(GraphFrontierNode other) {
            return Float.compare(this.g, other.g);
        }
    }
}

