/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.Composite;

public class Selector
extends Composite {
    private Behavior executing;
    private final Function<List<Behavior>, Behavior> selectionFunction;
    private static final Random RANDOM = new Random();
    private static final Function<List<Behavior>, Behavior> RANDOM_SELECTION = behaviors -> (Behavior)behaviors.get(RANDOM.nextInt(behaviors.size()));

    private Selector(Function<List<Behavior>, Behavior> selectionFunction, Collection<Behavior> behaviors) {
        super(behaviors);
        this.selectionFunction = selectionFunction;
    }

    public Behavior getNextBehavior() {
        return this.selectionFunction.apply(this.getBehaviors());
    }

    public Function<List<Behavior>, Behavior> getSelectionFunction() {
        return this.selectionFunction;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.executing != null) {
            this.stopExecution(this.executing);
        }
        this.executing = null;
    }

    @Override
    public BehaviorStatus run() {
        this.tickParallel();
        Enum status = null;
        if (this.executing == null) {
            this.executing = this.getNextBehavior();
            if (this.executing == null) {
                return BehaviorStatus.FAILURE;
            }
            if (!this.executing.shouldExecute()) {
                status = BehaviorStatus.FAILURE;
            }
        }
        if (status == null) {
            status = this.executing.run();
        }
        switch (1.$SwitchMap$net$citizensnpcs$api$ai$tree$BehaviorStatus[status.ordinal()]) {
            case 1: {
                this.getBehaviors().remove(this.executing);
                this.stopExecution(this.executing);
                this.executing = null;
                return BehaviorStatus.SUCCESS;
            }
            case 2: 
            case 3: {
                this.stopExecution(this.executing);
                this.executing = null;
            }
        }
        return status;
    }

    public String toString() {
        return "Selector [executing=" + this.executing + ", selectionFunction=" + this.selectionFunction + ", getBehaviors()=" + this.getBehaviors() + "]";
    }

    public static Builder selecting(Behavior ... behaviors) {
        return Selector.selecting(Arrays.asList(behaviors));
    }

    public static Builder selecting(Collection<Behavior> behaviors) {
        return new Builder(behaviors);
    }

    static /* synthetic */ Function access$000() {
        return RANDOM_SELECTION;
    }

    public static class Builder {
        private final Collection<Behavior> behaviors;
        private Function<List<Behavior>, Behavior> selectionFunction = Selector.access$000();

        private Builder(Collection<Behavior> behaviors) {
            this.behaviors = behaviors;
        }

        public Selector build() {
            return new Selector(this.selectionFunction, this.behaviors);
        }

        public Builder selectionFunction(Function<List<Behavior>, Behavior> function) {
            this.selectionFunction = function;
            return this;
        }
    }
}

