/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_14_R1.entity;

import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_14_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_14_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_14_R1.DamageSource;
import net.minecraft.server.v1_14_R1.EntityBoat;
import net.minecraft.server.v1_14_R1.EntityHuman;
import net.minecraft.server.v1_14_R1.EntityLiving;
import net.minecraft.server.v1_14_R1.EntityMinecartAbstract;
import net.minecraft.server.v1_14_R1.EntityParrot;
import net.minecraft.server.v1_14_R1.EntityTypes;
import net.minecraft.server.v1_14_R1.EnumHand;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.SoundEffect;
import net.minecraft.server.v1_14_R1.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_14_R1.CraftServer;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftParrot;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Parrot;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class ParrotController
extends MobEntityController {
    public ParrotController() {
        super(EntityParrotNPC.class);
    }

    public Parrot getBukkitEntity() {
        return (Parrot)super.getBukkitEntity();
    }

    public static class EntityParrotNPC
    extends EntityParrot
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityParrotNPC(EntityTypes<? extends EntityParrot> types, World world) {
            this(types, world, null);
        }

        public EntityParrotNPC(EntityTypes<? extends EntityParrot> types, World world, NPC npc) {
            super(types, world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMSImpl.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        public boolean a(EntityHuman paramEntityHuman, EnumHand paramEnumHand) {
            if (this.npc == null || !((Boolean)this.npc.data().get("protected", (Object)true)).booleanValue()) {
                return super.a(paramEntityHuman, paramEnumHand);
            }
            return false;
        }

        protected void checkDespawn() {
            if (this.npc == null) {
                super.checkDespawn();
            }
        }

        public void collide(net.minecraft.server.v1_14_R1.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void enderTeleportTo(double d0, double d1, double d2) {
            if (this.npc == null) {
                super.enderTeleportTo(d0, d1, d2);
                return;
            }
            NPCEnderTeleportEvent event = new NPCEnderTeleportEvent((NPC)this.npc);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                super.enderTeleportTo(d0, d1, d2);
            }
        }

        public void f(double x, double y, double z) {
            Vector vector = Util.callPushEvent((NPC)this.npc, (double)x, (double)y, (double)z);
            if (vector != null) {
                super.f(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.server.v1_14_R1.Entity)this, (CraftEntity)new ParrotNPC(this));
            }
            return super.getBukkitEntity();
        }

        public NPC getNPC() {
            return this.npc;
        }

        public SoundEffect getSoundAmbient() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.getSoundAmbient(), "ambient-sound");
        }

        protected SoundEffect getSoundDeath() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.getSoundDeath(), "death-sound");
        }

        protected SoundEffect getSoundHurt(DamageSource damagesource) {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.getSoundHurt(damagesource), "hurt-sound");
        }

        public boolean isLeashed() {
            if (this.npc == null) {
                return super.isLeashed();
            }
            boolean protectedDefault = (Boolean)this.npc.data().get("protected", (Object)true);
            if (!protectedDefault || !((Boolean)this.npc.data().get("protected-leash", (Object)protectedDefault)).booleanValue()) {
                return super.isLeashed();
            }
            if (super.isLeashed()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void mobTick() {
            if (this.npc == null) {
                super.mobTick();
            } else {
                NMSImpl.updateAI((EntityLiving)this);
                this.npc.update();
            }
        }

        protected boolean n(net.minecraft.server.v1_14_R1.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return (Boolean)this.npc.data().get("protected", (Object)true) == false;
            }
            return super.n(entity);
        }
    }

    public static class ParrotNPC
    extends CraftParrot
    implements NPCHolder {
        private final CitizensNPC npc;

        public ParrotNPC(EntityParrotNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityParrot)entity);
            this.npc = entity.npc;
        }

        public NPC getNPC() {
            return this.npc;
        }
    }
}

