/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_14_R1.entity;

import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_14_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_14_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.versioned.PufferFishTrait;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.ControllerMove;
import net.minecraft.server.v1_14_R1.DamageSource;
import net.minecraft.server.v1_14_R1.EntityBoat;
import net.minecraft.server.v1_14_R1.EntityHuman;
import net.minecraft.server.v1_14_R1.EntityInsentient;
import net.minecraft.server.v1_14_R1.EntityLiving;
import net.minecraft.server.v1_14_R1.EntityMinecartAbstract;
import net.minecraft.server.v1_14_R1.EntityPose;
import net.minecraft.server.v1_14_R1.EntityPufferFish;
import net.minecraft.server.v1_14_R1.EntitySize;
import net.minecraft.server.v1_14_R1.EntityTypes;
import net.minecraft.server.v1_14_R1.EnumHand;
import net.minecraft.server.v1_14_R1.IBlockData;
import net.minecraft.server.v1_14_R1.ItemStack;
import net.minecraft.server.v1_14_R1.Items;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.SoundEffect;
import net.minecraft.server.v1_14_R1.Vec3D;
import net.minecraft.server.v1_14_R1.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_14_R1.CraftServer;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPufferFish;
import org.bukkit.entity.Entity;
import org.bukkit.entity.PufferFish;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class PufferFishController
extends MobEntityController {
    public PufferFishController() {
        super(EntityPufferFishNPC.class);
    }

    public PufferFish getBukkitEntity() {
        return (PufferFish)super.getBukkitEntity();
    }

    public static class EntityPufferFishNPC
    extends EntityPufferFish
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityPufferFishNPC(EntityTypes<? extends EntityPufferFish> types, World world) {
            this(types, world, null);
        }

        public EntityPufferFishNPC(EntityTypes<? extends EntityPufferFish> types, World world, NPC npc) {
            super(types, world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMSImpl.clearGoals(this.goalSelector, this.targetSelector);
                this.moveController = new ControllerMove((EntityInsentient)this);
            }
        }

        protected void a(double d0, boolean flag, IBlockData block, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, block, blockposition);
            }
        }

        public boolean a(EntityHuman entityhuman, EnumHand enumhand) {
            if (this.npc == null || !this.npc.isProtected()) {
                return super.a(entityhuman, enumhand);
            }
            ItemStack itemstack = entityhuman.b(enumhand);
            if (itemstack.getItem() == Items.WATER_BUCKET && this.isAlive()) {
                return false;
            }
            return super.a(entityhuman, enumhand);
        }

        public EntitySize a(EntityPose entitypose) {
            if (this.npc == null) {
                return super.a(entitypose);
            }
            return super.a(entitypose).a(1.0f / EntityPufferFishNPC.s(this.getPuffState())).a(0.5f);
        }

        public void b(float f, float f1) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.b(f, f1);
            }
        }

        protected void checkDespawn() {
            if (this.npc == null) {
                super.checkDespawn();
            }
        }

        public void collide(net.minecraft.server.v1_14_R1.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void e(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                if (!NMSImpl.moveFish((NPC)this.npc, (EntityInsentient)this, vec3d)) {
                    super.e(vec3d);
                }
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
            }
        }

        public void enderTeleportTo(double d0, double d1, double d2) {
            if (this.npc == null) {
                super.enderTeleportTo(d0, d1, d2);
                return;
            }
            NPCEnderTeleportEvent event = new NPCEnderTeleportEvent((NPC)this.npc);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                super.enderTeleportTo(d0, d1, d2);
            }
        }

        public void f(double x, double y, double z) {
            Vector vector = Util.callPushEvent((NPC)this.npc, (double)x, (double)y, (double)z);
            if (vector != null) {
                super.f(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.server.v1_14_R1.Entity)this, (CraftEntity)new PufferFishNPC(this));
            }
            return super.getBukkitEntity();
        }

        public NPC getNPC() {
            return this.npc;
        }

        protected SoundEffect getSoundAmbient() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.getSoundAmbient(), "ambient-sound");
        }

        protected SoundEffect getSoundDeath() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.getSoundDeath(), "death-sound");
        }

        protected SoundEffect getSoundHurt(DamageSource damagesource) {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.getSoundHurt(damagesource), "hurt-sound");
        }

        public boolean isClimbing() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.isClimbing();
            }
            return false;
        }

        public boolean isLeashed() {
            if (this.npc == null) {
                return super.isLeashed();
            }
            boolean protectedDefault = (Boolean)this.npc.data().get("protected", (Object)true);
            if (!protectedDefault || !((Boolean)this.npc.data().get("protected-leash", (Object)protectedDefault)).booleanValue()) {
                return super.isLeashed();
            }
            if (super.isLeashed()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void mobTick() {
            super.mobTick();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public void movementTick() {
            boolean lastInWater = this.y;
            int lastPuffState = this.getPuffState();
            if (this.npc != null) {
                this.y = false;
                this.setPuffState(0);
            }
            super.movementTick();
            if (this.npc != null) {
                this.y = lastInWater;
                this.setPuffState(lastPuffState);
            }
        }

        protected boolean n(net.minecraft.server.v1_14_R1.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return (Boolean)this.npc.data().get("protected", (Object)true) == false;
            }
            return super.n(entity);
        }

        public void tick() {
            if (this.npc != null) {
                NMSImpl.resetPuffTicks(this);
            }
            super.tick();
            if (this.npc != null && this.npc.hasTrait(PufferFishTrait.class)) {
                this.setPuffState(((PufferFishTrait)this.npc.getOrAddTrait(PufferFishTrait.class)).getPuffState());
            }
        }

        private static float s(int i) {
            switch (i) {
                case 0: {
                    return 0.5f;
                }
                case 1: {
                    return 0.7f;
                }
            }
            return 1.0f;
        }
    }

    public static class PufferFishNPC
    extends CraftPufferFish
    implements NPCHolder {
        private final CitizensNPC npc;

        public PufferFishNPC(EntityPufferFishNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPufferFish)entity);
            this.npc = entity.npc;
        }

        public NPC getNPC() {
            return this.npc;
        }
    }
}

