/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_14_R1.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_14_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_14_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_14_R1.EntityEvokerFangs;
import net.minecraft.server.v1_14_R1.EntityHuman;
import net.minecraft.server.v1_14_R1.EntityTypes;
import net.minecraft.server.v1_14_R1.EnumHand;
import net.minecraft.server.v1_14_R1.EnumInteractionResult;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.Vec3D;
import net.minecraft.server.v1_14_R1.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_14_R1.CraftServer;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEvokerFangs;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.util.Vector;

public class EvokerFangsController
extends MobEntityController {
    public EvokerFangsController() {
        super(EntityEvokerFangsNPC.class);
    }

    public EvokerFangs getBukkitEntity() {
        return (EvokerFangs)super.getBukkitEntity();
    }

    public static class EntityEvokerFangsNPC
    extends EntityEvokerFangs
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEvokerFangsNPC(EntityTypes<? extends EntityEvokerFangs> types, World world) {
            this(types, world, null);
        }

        public EntityEvokerFangsNPC(EntityTypes<? extends EntityEvokerFangs> types, World world, NPC npc) {
            super(types, world);
            this.npc = (CitizensNPC)npc;
        }

        public EnumInteractionResult a(EntityHuman entityhuman, Vec3D vec3d, EnumHand enumhand) {
            if (this.npc == null) {
                return super.a(entityhuman, vec3d, enumhand);
            }
            PlayerInteractEntityEvent event = new PlayerInteractEntityEvent((Player)entityhuman.getBukkitEntity(), (Entity)this.getBukkitEntity());
            Bukkit.getPluginManager().callEvent((Event)event);
            return event.isCancelled() ? EnumInteractionResult.FAIL : EnumInteractionResult.SUCCESS;
        }

        public void collide(net.minecraft.server.v1_14_R1.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void f(double x, double y, double z) {
            Vector vector = Util.callPushEvent((NPC)this.npc, (double)x, (double)y, (double)z);
            if (vector != null) {
                super.f(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.server.v1_14_R1.Entity)this, (CraftEntity)new EvokerFangsNPC(this));
            }
            return super.getBukkitEntity();
        }

        public NPC getNPC() {
            return this.npc;
        }

        public void tick() {
            super.tick();
            if (this.npc != null) {
                this.npc.update();
            }
        }
    }

    public static class EvokerFangsNPC
    extends CraftEvokerFangs
    implements NPCHolder {
        private final CitizensNPC npc;

        public EvokerFangsNPC(EntityEvokerFangsNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityEvokerFangs)entity);
            this.npc = entity.npc;
        }

        public NPC getNPC() {
            return this.npc;
        }
    }
}

