/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_14_R1.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_14_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_14_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_14_R1.EntityPotion;
import net.minecraft.server.v1_14_R1.EntityTypes;
import net.minecraft.server.v1_14_R1.Items;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_14_R1.CraftServer;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftThrownPotion;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.util.Vector;

public class ThrownPotionController
extends MobEntityController {
    public ThrownPotionController() {
        super(EntityThrownPotionNPC.class);
    }

    public ThrownPotion getBukkitEntity() {
        return (ThrownPotion)super.getBukkitEntity();
    }

    public static class EntityThrownPotionNPC
    extends EntityPotion
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityThrownPotionNPC(EntityTypes<? extends EntityPotion> types, World world) {
            this(types, world, null);
        }

        public EntityThrownPotionNPC(EntityTypes<? extends EntityPotion> types, World world, NPC npc) {
            super(types, world);
            this.npc = (CitizensNPC)npc;
        }

        public void collide(net.minecraft.server.v1_14_R1.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void f(double x, double y, double z) {
            Vector vector = Util.callPushEvent((NPC)this.npc, (double)x, (double)y, (double)z);
            if (vector != null) {
                super.f(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                if (this.getItem() != null && this.getItem().getItem().equals(Items.LINGERING_POTION)) {
                    NMSImpl.setBukkitEntity((net.minecraft.server.v1_14_R1.Entity)this, (CraftEntity)new LingeringThrownPotionNPC(this));
                } else {
                    NMSImpl.setBukkitEntity((net.minecraft.server.v1_14_R1.Entity)this, (CraftEntity)new SplashThrownPotionNPC(this));
                }
            }
            return super.getBukkitEntity();
        }

        public NPC getNPC() {
            return this.npc;
        }

        public void tick() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.tick();
            }
        }
    }

    public static class LingeringThrownPotionNPC
    extends CraftThrownPotion
    implements NPCHolder {
        private final CitizensNPC npc;

        public LingeringThrownPotionNPC(EntityThrownPotionNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPotion)entity);
            this.npc = entity.npc;
        }

        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class SplashThrownPotionNPC
    extends CraftThrownPotion
    implements NPCHolder {
        private final CitizensNPC npc;

        public SplashThrownPotionNPC(EntityThrownPotionNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPotion)entity);
            this.npc = entity.npc;
        }

        public NPC getNPC() {
            return this.npc;
        }
    }
}

