/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_14_R1.util;

import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandle;
import java.util.EnumMap;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.nms.v1_14_R1.util.NMSImpl;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import net.minecraft.server.v1_14_R1.EntityPlayer;
import net.minecraft.server.v1_14_R1.EntityPose;
import net.minecraft.server.v1_14_R1.EnumHand;
import net.minecraft.server.v1_14_R1.Packet;
import net.minecraft.server.v1_14_R1.PacketPlayOutAnimation;
import net.minecraft.server.v1_14_R1.PacketPlayOutEntityMetadata;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerAnimationImpl {
    private static EnumMap<PlayerAnimation, Integer> DEFAULTS = Maps.newEnumMap(PlayerAnimation.class);
    private static final MethodHandle ENTITY_SETPOSE_METHOD = NMS.getMethodHandle(net.minecraft.server.v1_14_R1.Entity.class, (String)"setPose", (boolean)true, (Class[])new Class[]{EntityPose.class});

    static {
        DEFAULTS.put(PlayerAnimation.ARM_SWING, 0);
        DEFAULTS.put(PlayerAnimation.HURT, 1);
        DEFAULTS.put(PlayerAnimation.EAT_FOOD, 2);
        DEFAULTS.put(PlayerAnimation.ARM_SWING_OFFHAND, 3);
        DEFAULTS.put(PlayerAnimation.CRIT, 4);
        DEFAULTS.put(PlayerAnimation.MAGIC_CRIT, 5);
    }

    public static void play(PlayerAnimation animation, Player bplayer, int radius) {
        final EntityPlayer player = (EntityPlayer)NMSImpl.getHandle((Entity)bplayer);
        if (DEFAULTS.containsKey(animation)) {
            PlayerAnimationImpl.playDefaultAnimation(player, radius, DEFAULTS.get(animation));
            return;
        }
        switch (animation) {
            case SIT: {
                player.getBukkitEntity().setMetadata("citizens.sitting", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)true));
                NPCRegistry registry = CitizensAPI.getNamedNPCRegistry((String)"PlayerAnimationImpl");
                if (registry == null) {
                    registry = CitizensAPI.createNamedNPCRegistry((String)"PlayerAnimationImpl", (NPCDataStore)new MemoryNPCDataStore());
                }
                final NPC holder = registry.createNPC(EntityType.ARMOR_STAND, "");
                ((ArmorStandTrait)holder.getOrAddTrait(ArmorStandTrait.class)).setAsPointEntity();
                holder.spawn(player.getBukkitEntity().getLocation());
                new BukkitRunnable(){

                    public void cancel() {
                        super.cancel();
                        holder.destroy();
                    }

                    public void run() {
                        if (player.dead || !player.valid || !player.getBukkitEntity().hasMetadata("citizens.sitting") || !((MetadataValue)player.getBukkitEntity().getMetadata("citizens.sitting").get(0)).asBoolean()) {
                            this.cancel();
                            return;
                        }
                        if (player instanceof NPCHolder && !((NPCHolder)player).getNPC().isSpawned()) {
                            this.cancel();
                            return;
                        }
                        if (!NMS.getPassengers((Entity)holder.getEntity()).contains(player.getBukkitEntity())) {
                            NMS.mount((Entity)holder.getEntity(), (Entity)player.getBukkitEntity());
                        }
                    }
                }.runTaskTimer(CitizensAPI.getPlugin(), 0L, 1L);
                break;
            }
            case SLEEP: {
                try {
                    ENTITY_SETPOSE_METHOD.invoke(player, EntityPose.SLEEPING);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                break;
            }
            case SNEAK: {
                player.getBukkitEntity().setSneaking(true);
                PlayerAnimationImpl.sendPacketNearby(new PacketPlayOutEntityMetadata(player.getId(), player.getDataWatcher(), true), player, radius);
                break;
            }
            case START_ELYTRA: {
                player.J();
                break;
            }
            case START_USE_MAINHAND_ITEM: {
                player.c(EnumHand.MAIN_HAND);
                PlayerAnimationImpl.sendPacketNearby(new PacketPlayOutEntityMetadata(player.getId(), player.getDataWatcher(), true), player, radius);
                break;
            }
            case START_USE_OFFHAND_ITEM: {
                player.c(EnumHand.OFF_HAND);
                PlayerAnimationImpl.sendPacketNearby(new PacketPlayOutEntityMetadata(player.getId(), player.getDataWatcher(), true), player, radius);
                break;
            }
            case STOP_SITTING: {
                player.getBukkitEntity().setMetadata("citizens.sitting", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)false));
                NMS.mount((Entity)player.getBukkitEntity(), null);
                break;
            }
            case STOP_SLEEPING: {
                try {
                    ENTITY_SETPOSE_METHOD.invoke(player, EntityPose.STANDING);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                break;
            }
            case STOP_SNEAKING: {
                player.getBukkitEntity().setSneaking(false);
                PlayerAnimationImpl.sendPacketNearby(new PacketPlayOutEntityMetadata(player.getId(), player.getDataWatcher(), true), player, radius);
                break;
            }
            case STOP_USE_ITEM: {
                player.clearActiveItem();
                PlayerAnimationImpl.sendPacketNearby(new PacketPlayOutEntityMetadata(player.getId(), player.getDataWatcher(), true), player, radius);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static void playDefaultAnimation(EntityPlayer player, int radius, int code) {
        PacketPlayOutAnimation packet = new PacketPlayOutAnimation((net.minecraft.server.v1_14_R1.Entity)player, code);
        PlayerAnimationImpl.sendPacketNearby(packet, player, radius);
    }

    protected static void sendPacketNearby(Packet<?> packet, EntityPlayer player, int radius) {
        NMSImpl.sendPacketNearby((Player)player.getBukkitEntity(), player.getBukkitEntity().getLocation(), packet, radius);
    }
}

