/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_20_R4.entity.MobEntityController;
import net.citizensnpcs.nms.v1_20_R4.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_20_R4.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.versioned.EnderDragonTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;

public class EnderDragonController
extends MobEntityController {
    public EnderDragonController() {
        super(EntityEnderDragonNPC.class);
    }

    public EnderDragon getBukkitEntity() {
        return (EnderDragon)super.getBukkitEntity();
    }

    public static class EntityEnderDragonNPC
    extends EntityEnderDragon
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> types, World level) {
            this(types, level, null);
        }

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public void n_() {
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState((NPC)this.npc, (EntityInsentient)this);
                this.npc.update();
            }
            if (this.npc != null && !this.npc.useMinecraftAI()) {
                if (this.eB()) {
                    this.t(0.0f);
                    return;
                }
                if (this.d < 0) {
                    for (int i = 0; i < this.c.length; ++i) {
                        this.c[i][0] = this.dF();
                        this.c[i][1] = this.dw();
                    }
                }
                if (++this.d == this.c.length) {
                    this.d = 0;
                }
                this.c[this.d][0] = this.dF();
                this.c[this.d][1] = this.dw();
                float[][] pos = NMS.calculateDragonPositions((float)this.dF(), (double[][])new double[][]{this.a(0, 1.0f), this.a(5, 1.0f), this.a(10, 1.0f), this.a(12, 1.0f), this.a(14, 1.0f), this.a(16, 1.0f)});
                for (int j = 0; j < this.ck.length; ++j) {
                    Vec3D vec3 = new Vec3D(this.ck[j].du(), this.ck[j].dw(), this.ck[j].dA());
                    this.ck[j].a_(this.du() + (double)pos[j][0], this.dw() + (double)pos[j][1], this.dA() + (double)pos[j][2]);
                    this.ck[j].L = this.ck[j].ad = vec3.c;
                    this.ck[j].M = this.ck[j].ae = vec3.d;
                    this.ck[j].N = this.ck[j].af = vec3.e;
                }
                if (this.cT() != null) {
                    this.r(this.cT().getBukkitYaw() - 180.0f);
                }
                Vec3D mot = this.ds();
                if (mot.c != 0.0 || mot.d != 0.0 || mot.e != 0.0) {
                    if (this.cT() == null) {
                        this.r(Util.getYawFromVelocity((Entity)this.getBukkitEntity(), (double)mot.c, (double)mot.e));
                    }
                    this.a(EnumMoveType.a, mot);
                    mot = mot.d(0.98, 0.91, 0.98);
                    this.h(mot);
                }
                if (this.npc.hasTrait(EnderDragonTrait.class) && ((EnderDragonTrait)this.npc.getOrAddTrait(EnderDragonTrait.class)).isDestroyWalls() && NMSImpl.ENDERDRAGON_CHECK_WALLS != null) {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            this.bZ |= NMSImpl.ENDERDRAGON_CHECK_WALLS.invoke(this, this.ck[i].cK());
                            continue;
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)false)).booleanValue()) {
                    try {
                        NMSImpl.ENDERDRAGON_KNOCKBACK.invoke(this, this.dP().a((net.minecraft.world.entity.Entity)this, this.ck[6].cK().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        NMSImpl.ENDERDRAGON_KNOCKBACK.invoke(this, this.dP().a((net.minecraft.world.entity.Entity)this, this.ck[7].cK().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        NMSImpl.ENDERDRAGON_HURT.invoke(this, this.dP().a((net.minecraft.world.entity.Entity)this, this.ck[0].cK().g(1.0), IEntitySelector.e));
                        NMSImpl.ENDERDRAGON_HURT.invoke(this, this.dP().a((net.minecraft.world.entity.Entity)this, this.ck[1].cK().g(1.0), IEntitySelector.e));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            } else {
                super.n_();
            }
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        protected boolean o(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.o(entity);
        }

        public void dB() {
            if (this.npc == null) {
                super.dB();
            }
        }

        protected SoundEffect v() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.v(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new EnderDragonNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect o_() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.o_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect d(DamageSource damagesource) {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.d(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fh() {
            return NMS.getJumpPower((NPC)this.npc, (float)super.fh());
        }

        public int cx() {
            return NMS.getFallDistance((NPC)this.npc, (int)super.cx());
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction k_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.k_();
        }

        public boolean gd() {
            return NMSImpl.isLeashed((NPC)this.npc, () -> super.gd(), (EntityInsentient)this);
        }

        public boolean bA() {
            return this.npc == null ? super.bA() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        public void q(double strength, double dx, double dz) {
            NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.q((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB as() {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.as());
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        protected boolean g(DamageSource source, float f) {
            if (this.npc == null) {
                return super.g(source, f);
            }
            Vec3D old = this.ds();
            boolean res = super.g(source, f);
            if (this.gn().a().i() == DragonControllerPhase.k) {
                this.h(old);
            }
            return res;
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(WorldServer worldserver, Vec3D location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.ds().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.h(old);
            }
            return res;
        }
    }

    public static class EnderDragonNPC
    extends CraftEnderDragon
    implements ForwardingNPCHolder {
        public EnderDragonNPC(EntityEnderDragonNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityEnderDragon)entity);
        }
    }
}

