/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R3.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R3.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_21_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPhantom;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Phantom;

public class PhantomController
extends MobEntityController {
    public PhantomController() {
        super(EntityPhantomNPC.class, EntityTypes.aP);
    }

    public Phantom getBukkitEntity() {
        return (Phantom)super.getBukkitEntity();
    }

    public static class EntityPhantomNPC
    extends EntityPhantom
    implements NPCHolder {
        private final CitizensNPC npc;
        private ControllerLook oldLookController;
        private ControllerMove oldMoveController;

        public EntityPhantomNPC(EntityTypes<? extends EntityPhantom> types, World level) {
            this(types, level, null);
        }

        public EntityPhantomNPC(EntityTypes<? extends EntityPhantom> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.oldMoveController = this.bP;
                this.oldLookController = this.bO;
                this.bP = new ControllerMove((EntityInsentient)this);
                this.bO = new ControllerLook((EntityInsentient)this);
            }
        }

        public void d_() {
            super.d_();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState((NPC)this.npc, (EntityInsentient)this);
                if (this.npc.useMinecraftAI() && this.bP != this.oldMoveController) {
                    this.bP = this.oldMoveController;
                    this.bO = this.oldLookController;
                }
                if (!this.npc.useMinecraftAI() && this.bP == this.oldMoveController) {
                    this.bP = new EntityMoveControl((EntityLiving)this);
                    this.bO = new ControllerLook((EntityInsentient)this);
                }
                if (this.npc.isProtected()) {
                    this.d(0.0f);
                }
                this.npc.update();
            }
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        protected boolean o(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.o(entity);
        }

        public void dH() {
            if (this.npc == null) {
                super.dH();
            }
        }

        protected SoundEffect u() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.u(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new PhantomNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect o_() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.o_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect e(DamageSource damagesource) {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.e(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fj() {
            return NMS.getJumpPower((NPC)this.npc, (float)super.fj());
        }

        public int cE() {
            return NMS.getFallDistance((NPC)this.npc, (int)super.cE());
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction n_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.n_();
        }

        public boolean P_() {
            return NMSImpl.isLeashed((NPC)this.npc, () -> super.P_(), (EntityInsentient)this);
        }

        public boolean bI() {
            return this.npc == null ? super.bI() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        public boolean gk() {
            if (this.npc == null || !this.npc.isProtected()) {
                return super.gk();
            }
            return false;
        }

        public void p(double strength, double dx, double dz) {
            NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.p((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.c(vec3));
        }

        public void a(DataWatcherObject<?> datawatcherobject) {
            if (this.npc == null) {
                super.a(datawatcherobject);
                return;
            }
            NMSImpl.checkAndUpdateHeight((EntityLiving)this, datawatcherobject, x$0 -> super.a(x$0));
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        protected boolean ab() {
            return this.npc != null ? false : super.ab();
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dy().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.i(old);
            }
            return res;
        }
    }

    public static class PhantomNPC
    extends CraftPhantom
    implements ForwardingNPCHolder {
        public PhantomNPC(EntityPhantomNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPhantom)entity);
        }
    }
}

