/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R3.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_21_R3.util.EntityJumpControl;
import net.citizensnpcs.nms.v1_21_R3.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_21_R3.util.EntityNavigation;
import net.citizensnpcs.nms.v1_21_R3.util.NMSImpl;
import org.bukkit.entity.Entity;

public interface MobAI {
    public Entity getBukkitEntity();

    public cbh getJumpControl();

    public Map<etr, Float> getMalus();

    public cbj getMoveControl();

    public ceu getNavigation();

    default public float getPathfindingMalus(etr var1) {
        Map<etr, Float> malus = this.getMalus();
        return malus.containsKey(var1) ? malus.get(var1).floatValue() : var1.a();
    }

    default public void setPathfindingMalus(etr water, float oldWaterCost) {
        this.getMalus().put(water, Float.valueOf(oldWaterCost));
    }

    default public void tickAI() {
        this.getJumpControl().b();
        this.getMoveControl().a();
        ceu nav = this.getNavigation();
        if (!nav.k()) {
            nav.c();
        }
    }

    default public void updatePathfindingRange(float range) {
        ((bvi)NMSImpl.getHandle(this.getBukkitEntity())).g(bwq.m).a((double)range);
    }

    public static MobAI from(bum handle) {
        if (handle instanceof bvk) {
            final bvk mob = (bvk)handle;
            return new MobAI(){

                @Override
                public Entity getBukkitEntity() {
                    return mob.getBukkitEntity();
                }

                @Override
                public cbh getJumpControl() {
                    return mob.O();
                }

                @Override
                public Map<etr, Float> getMalus() {
                    return null;
                }

                @Override
                public cbj getMoveControl() {
                    return mob.N();
                }

                @Override
                public ceu getNavigation() {
                    return mob.P();
                }

                @Override
                public float getPathfindingMalus(etr var1) {
                    return mob.a(var1);
                }

                @Override
                public void setPathfindingMalus(etr water, float oldWaterCost) {
                    mob.a(water, oldWaterCost);
                }

                @Override
                public void tickAI() {
                    mob.Q().a();
                    mob.P().c();
                    mob.N().a();
                    mob.L().a();
                    mob.O().b();
                }
            };
        }
        if (handle instanceof MobAI) {
            return (MobAI)handle;
        }
        return null;
    }

    public static interface ForwardingMobAI
    extends MobAI {
        public MobAI getAI();

        @Override
        default public Entity getBukkitEntity() {
            return this.getAI().getBukkitEntity();
        }

        @Override
        default public cbh getJumpControl() {
            return this.getAI().getJumpControl();
        }

        @Override
        default public Map<etr, Float> getMalus() {
            return this.getAI().getMalus();
        }

        @Override
        default public cbj getMoveControl() {
            return this.getAI().getMoveControl();
        }

        @Override
        default public ceu getNavigation() {
            return this.getAI().getNavigation();
        }
    }

    public static class BasicMobAI
    implements MobAI {
        private final EntityJumpControl controllerJump;
        private final EntityMoveControl controllerMove;
        private final bvi entity;
        private final Map<etr, Float> malus;
        private final EntityNavigation navigation;

        public BasicMobAI(bvi entity) {
            this.entity = entity;
            NMSImpl.setAttribute(entity, (jr<bwl>)bwq.m, Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
            entity.g(bwq.v).a(0.3);
            this.controllerJump = new EntityJumpControl(entity);
            this.controllerMove = new EntityMoveControl(entity);
            this.navigation = new EntityNavigation(entity, entity.dV());
            this.malus = Maps.newEnumMap(etr.class);
        }

        @Override
        public Entity getBukkitEntity() {
            return this.entity.getBukkitEntity();
        }

        @Override
        public cbh getJumpControl() {
            return this.controllerJump;
        }

        @Override
        public Map<etr, Float> getMalus() {
            return this.malus;
        }

        @Override
        public cbj getMoveControl() {
            return this.controllerMove;
        }

        @Override
        public ceu getNavigation() {
            return this.navigation;
        }
    }
}

