/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R3.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.nms.v1_21_R3.util.NMSImpl;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class PlayerAnimationImpl {
    private static Map<PlayerAnimation, Integer> DEFAULTS = Maps.newEnumMap(PlayerAnimation.class);

    public static void play(PlayerAnimation animation, Player bplayer, Iterable<Player> to) {
        are player = (are)NMSImpl.getHandle((Entity)bplayer);
        if (DEFAULTS.containsKey(animation)) {
            PlayerAnimationImpl.playDefaultAnimation(player, to, DEFAULTS.get(animation));
            return;
        }
        switch (animation) {
            case HURT: {
                PlayerAnimationImpl.sendPacketNearby(new acv((bvi)player), to);
                break;
            }
            case SNEAK: {
                player.b(bvu.f);
                PlayerAnimationImpl.sendEntityData(to, player);
                break;
            }
            case START_ELYTRA: {
                player.gp();
                break;
            }
            case STOP_ELYTRA: {
                player.gq();
                break;
            }
            case START_USE_MAINHAND_ITEM: {
                player.c(bsk.a);
                PlayerAnimationImpl.sendEntityData(to, player);
                player.getBukkitEntity().setMetadata("citizens-using-item-remaining-ticks", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)player.fC()));
                break;
            }
            case START_USE_OFFHAND_ITEM: {
                player.c(bsk.b);
                PlayerAnimationImpl.sendEntityData(to, player);
                player.getBukkitEntity().setMetadata("citizens-using-item-remaining-ticks", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)player.fC()));
                break;
            }
            case STOP_SNEAKING: {
                player.b(bvu.a);
                PlayerAnimationImpl.sendEntityData(to, player);
                break;
            }
            case STOP_USE_ITEM: {
                player.fF();
                PlayerAnimationImpl.sendEntityData(to, player);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static void playDefaultAnimation(are player, Iterable<Player> to, int code) {
        abo packet = new abo((bum)player, code);
        PlayerAnimationImpl.sendPacketNearby(packet, to);
    }

    private static void sendEntityData(Iterable<Player> to, are player) {
        if (!player.au().a()) {
            return;
        }
        PlayerAnimationImpl.sendPacketNearby(new aev(player.ar(), player.au().b()), to);
    }

    protected static void sendPacketNearby(yw<?> packet, Iterable<Player> to) {
        for (Player player : to) {
            NMSImpl.sendPacket(player, packet);
        }
    }

    static {
        DEFAULTS.put(PlayerAnimation.ARM_SWING, 0);
        DEFAULTS.put(PlayerAnimation.LEAVE_BED, 2);
        DEFAULTS.put(PlayerAnimation.ARM_SWING_OFFHAND, 3);
        DEFAULTS.put(PlayerAnimation.CRIT, 4);
        DEFAULTS.put(PlayerAnimation.MAGIC_CRIT, 5);
    }
}

