/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R4.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_21_R4.util.EntityJumpControl;
import net.citizensnpcs.nms.v1_21_R4.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_21_R4.util.EntityNavigation;
import net.citizensnpcs.nms.v1_21_R4.util.NMSImpl;
import org.bukkit.entity.Entity;

public interface MobAI {
    public Entity getBukkitEntity();

    public cec getJumpControl();

    public Map<eyr, Float> getMalus();

    public cee getMoveControl();

    public chp getNavigation();

    default public float getPathfindingMalus(eyr var1) {
        Map<eyr, Float> malus = this.getMalus();
        return malus.containsKey(var1) ? malus.get(var1).floatValue() : var1.a();
    }

    default public void setPathfindingMalus(eyr water, float oldWaterCost) {
        this.getMalus().put(water, Float.valueOf(oldWaterCost));
    }

    default public void tickAI() {
        this.getJumpControl().b();
        this.getMoveControl().a();
        chp nav = this.getNavigation();
        if (!nav.k()) {
            nav.c();
        }
    }

    default public void updatePathfindingRange(float range) {
        ((byf)NMSImpl.getHandle(this.getBukkitEntity())).g(bzl.m).a((double)range);
    }

    public static MobAI from(bxe handle) {
        if (handle instanceof byh) {
            final byh mob = (byh)handle;
            return new MobAI(){

                @Override
                public Entity getBukkitEntity() {
                    return mob.getBukkitEntity();
                }

                @Override
                public cec getJumpControl() {
                    return mob.M();
                }

                @Override
                public Map<eyr, Float> getMalus() {
                    return null;
                }

                @Override
                public cee getMoveControl() {
                    return mob.K();
                }

                @Override
                public chp getNavigation() {
                    return mob.N();
                }

                @Override
                public float getPathfindingMalus(eyr var1) {
                    return mob.a(var1);
                }

                @Override
                public void setPathfindingMalus(eyr water, float oldWaterCost) {
                    mob.a(water, oldWaterCost);
                }

                @Override
                public void tickAI() {
                    mob.O().a();
                    mob.N().c();
                    mob.K().a();
                    mob.I().a();
                    mob.M().b();
                }
            };
        }
        if (handle instanceof MobAI) {
            return (MobAI)handle;
        }
        return null;
    }

    public static interface ForwardingMobAI
    extends MobAI {
        public MobAI getAI();

        @Override
        default public Entity getBukkitEntity() {
            return this.getAI().getBukkitEntity();
        }

        @Override
        default public cec getJumpControl() {
            return this.getAI().getJumpControl();
        }

        @Override
        default public Map<eyr, Float> getMalus() {
            return this.getAI().getMalus();
        }

        @Override
        default public cee getMoveControl() {
            return this.getAI().getMoveControl();
        }

        @Override
        default public chp getNavigation() {
            return this.getAI().getNavigation();
        }
    }

    public static class BasicMobAI
    implements MobAI {
        private final EntityJumpControl controllerJump;
        private final EntityMoveControl controllerMove;
        private final byf entity;
        private final Map<eyr, Float> malus;
        private final EntityNavigation navigation;

        public BasicMobAI(byf entity) {
            this.entity = entity;
            NMSImpl.setAttribute(entity, (jg<bzg>)bzl.m, Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
            entity.g(bzl.v).a(0.3);
            this.controllerJump = new EntityJumpControl(entity);
            this.controllerMove = new EntityMoveControl(entity);
            this.navigation = new EntityNavigation(entity, entity.dV());
            this.malus = Maps.newEnumMap(eyr.class);
        }

        @Override
        public Entity getBukkitEntity() {
            return this.entity.getBukkitEntity();
        }

        @Override
        public cec getJumpControl() {
            return this.controllerJump;
        }

        @Override
        public Map<eyr, Float> getMalus() {
            return this.malus;
        }

        @Override
        public cee getMoveControl() {
            return this.controllerMove;
        }

        @Override
        public chp getNavigation() {
            return this.navigation;
        }
    }
}

