/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R5.util;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import java.util.Set;
import net.citizensnpcs.nms.v1_21_R5.util.EntityNodeEvaluatorBase;

public class EntityNodeEvaluator
extends EntityNodeEvaluatorBase {
    private final Object2BooleanMap collisionCache = new Object2BooleanOpenHashMap();
    protected float oldWaterCost;
    private final Long2ObjectMap pathTypesByPosCacheByMob = new Long2ObjectOpenHashMap();
    private final fax[] reusableNeighbors = new fax[jh.c.a.b()];
    public static final double SPACE_BETWEEN_WALL_POSTS = 0.5;

    private boolean canReachWithoutCollision(fax var0) {
        fin var1 = this.mob.cV();
        fis var2 = new fis((double)var0.a - this.mob.dC() + var1.b() / 2.0, (double)var0.b - this.mob.dE() + var1.c() / 2.0, (double)var0.c - this.mob.dI() + var1.d() / 2.0);
        int var3 = bcb.c((double)(var2.g() / var1.a()));
        var2 = var2.c((double)(1.0f / (float)var3));
        for (int var4 = 1; var4 <= var3; ++var4) {
            if (!this.hasCollisions(var1 = var1.c(var2))) continue;
            return false;
        }
        return true;
    }

    protected boolean canStartAt(jb var0) {
        fbc var1 = this.getCachedPathType(var0.u(), var0.v(), var0.w());
        return var1 != fbc.b && this.mvmt.getPathfindingMalus(var1) >= 0.0f;
    }

    @Override
    public void b() {
        this.mvmt.setPathfindingMalus(fbc.j, this.oldWaterCost);
        this.pathTypesByPosCacheByMob.clear();
        this.collisionCache.clear();
        super.b();
    }

    protected fax findAcceptedNode(int var0, int var1, int var2, int var3, double var4, jh var6, fbc var7) {
        fax var8 = null;
        jb.a var9 = new jb.a();
        double var10 = this.getFloorLevel((jb)var9.d(var0, var1, var2));
        if (var10 - var4 > this.getMobJumpHeight()) {
            return null;
        }
        fbc var12 = this.getCachedPathType(var0, var1, var2);
        float var13 = this.mvmt.getPathfindingMalus(var12);
        if (var13 >= 0.0f) {
            var8 = this.getNodeAndUpdateCostToMax(var0, var1, var2, var12, var13);
        }
        if (EntityNodeEvaluator.doesBlockHavePartialCollision(var7) && var8 != null && var8.k >= 0.0f && !this.canReachWithoutCollision(var8)) {
            var8 = null;
        }
        if (!(var12 == fbc.c || this.isAmphibious() && var12 == fbc.j)) {
            if ((var8 == null || var8.k < 0.0f) && var3 > 0 && (var12 != fbc.h || this.g()) && var12 != fbc.m && var12 != fbc.e && var12 != fbc.f) {
                var8 = this.tryJumpOn(var0, var1, var2, var3, var4, var6, var7, var9);
            } else if (!this.isAmphibious() && var12 == fbc.j && !this.f()) {
                var8 = this.tryFindFirstNonWaterBelow(var0, var1, var2, var8);
            } else if (var12 == fbc.b) {
                var8 = this.tryFindFirstGroundNodeBelow(var0, var1, var2);
            } else if (EntityNodeEvaluator.doesBlockHavePartialCollision(var12) && var8 == null) {
                var8 = this.getClosedNode(var0, var1, var2, var12);
            }
        }
        return var8;
    }

    private fax getBlockedNode(int var0, int var1, int var2) {
        fax var3 = this.c(var0, var1, var2);
        var3.l = fbc.a;
        var3.k = -1.0f;
        return var3;
    }

    protected fbc getCachedPathType(int var0, int var1, int var2) {
        return (fbc)this.pathTypesByPosCacheByMob.computeIfAbsent(jb.a((int)var0, (int)var1, (int)var2), var3 -> this.getPathTypeOfMob(this.b, var0, var1, var2, this.mob));
    }

    private fax getClosedNode(int var0, int var1, int var2, fbc var3) {
        fax var4 = this.c(var0, var1, var2);
        var4.i = true;
        var4.l = var3;
        var4.k = var3.a();
        return var4;
    }

    protected double getFloorLevel(jb var0) {
        dmc var1 = this.b.a();
        return (this.f() || this.isAmphibious()) && var1.b_(var0).a(azu.a) ? (double)var0.v() + 0.5 : EntityNodeEvaluator.getFloorLevel((dly)var1, var0);
    }

    private double getMobJumpHeight() {
        return Math.max(1.125, (double)this.mob.dT());
    }

    public int a(fax[] var0, fax var1) {
        jh var10;
        int var2 = 0;
        int var3 = 0;
        fbc var4 = this.getCachedPathType(var1.a, var1.b + 1, var1.c);
        fbc var5 = this.getCachedPathType(var1.a, var1.b, var1.c);
        if (this.mvmt.getPathfindingMalus(var4) >= 0.0f && var5 != fbc.w) {
            var3 = bcb.d((float)Math.max(1.0f, this.mob.dT()));
        }
        double var6 = this.getFloorLevel(new jb(var1.a, var1.b, var1.c));
        for (jh var9 : jh.c.a) {
            var10 = this.findAcceptedNode(var1.a + var9.j(), var1.b, var1.c + var9.l(), var3, var6, var9, var5);
            this.reusableNeighbors[var9.e()] = var10;
            if (!this.isNeighborValid((fax)var10, var1)) continue;
            var0[var2++] = var10;
        }
        for (jh var9 : jh.c.a) {
            fax var11;
            var10 = var9.h();
            if (!this.isDiagonalValid(var1, this.reusableNeighbors[var9.e()], this.reusableNeighbors[var10.e()]) || !this.isDiagonalValid(var11 = this.findAcceptedNode(var1.a + var9.j() + var10.j(), var1.b, var1.c + var9.l() + var10.l(), var3, var6, var9, var5))) continue;
            var0[var2++] = var11;
        }
        return var2;
    }

    private fax getNodeAndUpdateCostToMax(int var0, int var1, int var2, fbc var3, float var4) {
        fax var5 = this.c(var0, var1, var2);
        var5.l = var3;
        var5.k = Math.max(var5.k, var4);
        return var5;
    }

    public fbc a(fbe var0, int var1, int var2, int var3) {
        return EntityNodeEvaluator.getPathTypeStatic(var0, new jb.a(var1, var2, var3));
    }

    public fbc getPathTypeOfMob(fbe var0, int var1, int var2, int var3, cam var4) {
        Set var5 = this.getPathTypeWithinMobBB(var0, var1, var2, var3);
        if (var5.contains(fbc.h)) {
            return fbc.h;
        }
        if (var5.contains(fbc.m)) {
            return fbc.m;
        }
        fbc var6 = fbc.a;
        for (fbc var8 : var5) {
            if (this.mvmt.getPathfindingMalus(var8) < 0.0f) {
                return var8;
            }
            if (!(this.mvmt.getPathfindingMalus(var8) >= this.mvmt.getPathfindingMalus(var6))) continue;
            var6 = var8;
        }
        if (this.e <= 1 && var6 != fbc.b && this.mvmt.getPathfindingMalus(var6) == 0.0f && this.a(var0, var1, var2, var3) == fbc.b) {
            return fbc.b;
        }
        return var6;
    }

    public fbc a(fbe var0, int var1, int var2, int var3, cao var4) {
        Set var5 = this.getPathTypeWithinMobBB(var0, var1, var2, var3);
        if (var5.contains(fbc.h)) {
            return fbc.h;
        }
        if (var5.contains(fbc.m)) {
            return fbc.m;
        }
        fbc var6 = fbc.a;
        for (fbc var8 : var5) {
            if (var4.a(var8) < 0.0f) {
                return var8;
            }
            if (!(var4.a(var8) >= var4.a(var6))) continue;
            var6 = var8;
        }
        if (this.e <= 1 && var6 != fbc.b && var4.a(var6) == 0.0f && this.a(var0, var1, var2, var3) == fbc.b) {
            return fbc.b;
        }
        return var6;
    }

    public Set getPathTypeWithinMobBB(fbe var0, int var1, int var2, int var3) {
        EnumSet<fbc> var4 = EnumSet.noneOf(fbc.class);
        for (int var5 = 0; var5 < this.e; ++var5) {
            for (int var6 = 0; var6 < this.f; ++var6) {
                for (int var7 = 0; var7 < this.g; ++var7) {
                    int var8 = var5 + var1;
                    int var9 = var6 + var2;
                    int var10 = var7 + var3;
                    fbc var11 = this.a(var0, var8, var9, var10);
                    jb var12 = this.mob.dx();
                    boolean var13 = this.d();
                    if (var11 == fbc.s && this.e() && var13) {
                        var11 = fbc.d;
                    }
                    if (var11 == fbc.r && !var13) {
                        var11 = fbc.a;
                    }
                    if (var11 == fbc.l && this.a(var0, var12.u(), var12.v(), var12.w()) != fbc.l && this.a(var0, var12.u(), var12.v() - 1, var12.w()) != fbc.l) {
                        var11 = fbc.m;
                    }
                    var4.add(var11);
                }
            }
        }
        return var4;
    }

    public fax a() {
        jb var3;
        int var0;
        jb.a var1;
        block12: {
            var1 = new jb.a();
            var0 = this.mob.dD();
            eeb var2 = this.b.a((jb)var1.b(this.mob.dC(), (double)var0, this.mob.dI()));
            if (!this.mob.a(var2.y())) {
                if (this.f() && this.mob.bm()) {
                    while (true) {
                        if (!var2.a(dqb.J) && var2.y() != fam.c.a(false)) {
                            --var0;
                            break block12;
                        }
                        var2 = this.b.a((jb)var1.b(this.mob.dC(), (double)(++var0), this.mob.dI()));
                    }
                }
                if (this.mob.aK()) {
                    var0 = bcb.a((double)(this.mob.dE() + 0.5));
                } else {
                    var1.b(this.mob.dC(), this.mob.dE() + 1.0, this.mob.dI());
                    while (var1.v() > this.b.a().L_()) {
                        var0 = var1.v();
                        var1.q(var1.v() - 1);
                        var3 = this.b.a((jb)var1);
                        if (var3.l() || var3.a(fba.a)) continue;
                        break;
                    }
                }
            } else {
                while (true) {
                    if (!this.mob.a(var2.y())) {
                        --var0;
                        break;
                    }
                    var2 = this.b.a((jb)var1.b(this.mob.dC(), (double)(++var0), this.mob.dI()));
                }
            }
        }
        var3 = this.mob.dx();
        if (!this.canStartAt((jb)var1.d(var3.u(), var0, var3.w()))) {
            fin var4 = this.mob.cV();
            if (this.canStartAt((jb)var1.b(var4.a, (double)var0, var4.c)) || this.canStartAt((jb)var1.b(var4.a, (double)var0, var4.f)) || this.canStartAt((jb)var1.b(var4.d, (double)var0, var4.c)) || this.canStartAt((jb)var1.b(var4.d, (double)var0, var4.f))) {
                return this.getStartNode((jb)var1);
            }
        }
        return this.getStartNode(new jb(var3.u(), var0, var3.w()));
    }

    protected fax getStartNode(jb var0) {
        fax var1 = this.b(var0);
        var1.l = this.getCachedPathType(var1.a, var1.b, var1.c);
        var1.k = this.mvmt.getPathfindingMalus(var1.l);
        return var1;
    }

    public fbg a(double var0, double var2, double var4) {
        return this.b(var0, var2, var4);
    }

    private boolean hasCollisions(fin var0) {
        return this.collisionCache.computeIfAbsent((Object)var0, var1 -> !this.b.a().a((bzm)this.mob, var0));
    }

    protected boolean isAmphibious() {
        return false;
    }

    protected boolean isDiagonalValid(fax var0) {
        if (var0 == null || var0.i || var0.l == fbc.d) {
            return false;
        }
        return var0.k >= 0.0f;
    }

    protected boolean isDiagonalValid(fax var0, fax var1, fax var2) {
        if (var2 != null && var1 != null && var2.b <= var0.b && var1.b <= var0.b) {
            if (var1.l != fbc.d && var2.l != fbc.d) {
                boolean var3 = var2.l == fbc.h && var1.l == fbc.h && (double)this.mob.ds() < 0.5;
                return (var2.b < var0.b || var2.k >= 0.0f || var3) && (var1.b < var0.b || var1.k >= 0.0f || var3);
            }
            return false;
        }
        return false;
    }

    protected boolean isNeighborValid(fax var0, fax var1) {
        return var0 != null && !var0.i && (var0.k >= 0.0f || var1.k < 0.0f);
    }

    @Override
    public void prepare(dnh var0, cam var1) {
        super.prepare(var0, var1);
        this.oldWaterCost = this.mvmt.getPathfindingMalus(fbc.j);
    }

    @Override
    public void a(dnh var0, cao var1) {
        super.a(var0, var1);
        this.oldWaterCost = this.mvmt.getPathfindingMalus(fbc.j);
    }

    private fax tryFindFirstGroundNodeBelow(int var0, int var1, int var2) {
        for (int var3 = var1 - 1; var3 >= this.mob.ai().L_(); --var3) {
            if (var1 - var3 > this.mob.cI()) {
                return this.getBlockedNode(var0, var3, var2);
            }
            fbc var4 = this.getCachedPathType(var0, var3, var2);
            float var5 = this.mvmt.getPathfindingMalus(var4);
            if (var4 == fbc.b) continue;
            if (var5 >= 0.0f) {
                return this.getNodeAndUpdateCostToMax(var0, var3, var2, var4, var5);
            }
            return this.getBlockedNode(var0, var3, var2);
        }
        return this.getBlockedNode(var0, var1, var2);
    }

    private fax tryFindFirstNonWaterBelow(int var0, int var1, int var2, fax var3) {
        --var1;
        while (var1 > this.mob.ai().L_()) {
            fbc var4 = this.getCachedPathType(var0, var1, var2);
            if (var4 != fbc.j) {
                return var3;
            }
            var3 = this.getNodeAndUpdateCostToMax(var0, var1, var2, var4, this.mvmt.getPathfindingMalus(var4));
            --var1;
        }
        return var3;
    }

    private fax tryJumpOn(int var0, int var1, int var2, int var3, double var4, jh var6, fbc var7, jb.a var8) {
        fax var9 = this.findAcceptedNode(var0, var1 + 1, var2, var3 - 1, var4, var6, var7);
        if (var9 == null) {
            return null;
        }
        if (this.mob.ds() >= 1.0f || var9.l != fbc.b && var9.l != fbc.c) {
            return var9;
        }
        double var10 = (double)(var0 - var6.j()) + 0.5;
        double var12 = (double)(var2 - var6.l()) + 0.5;
        double var14 = (double)this.mob.ds() / 2.0;
        fin var16 = new fin(var10 - var14, this.getFloorLevel((jb)var8.b(var10, (double)(var1 + 1), var12)) + 0.001, var12 - var14, var10 + var14, (double)this.mob.dt() + this.getFloorLevel((jb)var8.b((double)var9.a, (double)var9.b, (double)var9.c)) - 0.002, var12 + var14);
        return this.hasCollisions(var16) ? null : var9;
    }

    public static fbc checkNeighbourBlocks(fbe var0, int var1, int var2, int var3, fbc var4) {
        for (int var5 = -1; var5 <= 1; ++var5) {
            for (int var6 = -1; var6 <= 1; ++var6) {
                for (int var7 = -1; var7 <= 1; ++var7) {
                    if (var5 == 0 && var7 == 0) continue;
                    fbc var8 = var0.a(var1 + var5, var2 + var6, var3 + var7);
                    if (var8 == fbc.q) {
                        return fbc.p;
                    }
                    if (var8 == fbc.o || var8 == fbc.i) {
                        return fbc.n;
                    }
                    if (var8 == fbc.j) {
                        return fbc.k;
                    }
                    if (var8 != fbc.y) continue;
                    return fbc.y;
                }
            }
        }
        return var4;
    }

    private static boolean doesBlockHavePartialCollision(fbc var0) {
        return var0 == fbc.h || var0 == fbc.s || var0 == fbc.t;
    }

    public static double getFloorLevel(dly var0, jb var1) {
        jb var2 = var1.e();
        fjm var3 = var0.a_(var2).g(var0, var2);
        return (double)var2.v() + (var3.c() ? 0.0 : var3.c(jh.a.b));
    }

    public static fbc getPathTypeStatic(fbe var0, jb.a var1) {
        int var4;
        int var3;
        int var2 = var1.u();
        fbc var5 = var0.a(var2, var3 = var1.v(), var4 = var1.w());
        if (var5 == fbc.b && var3 >= var0.a().L_() + 1) {
            fbc var10000;
            switch (var0.a(var2, var3 - 1, var4)) {
                case b: 
                case j: 
                case i: 
                case c: {
                    var10000 = fbc.b;
                    break;
                }
                case o: {
                    var10000 = fbc.o;
                    break;
                }
                case q: {
                    var10000 = fbc.q;
                    break;
                }
                case w: {
                    var10000 = fbc.w;
                    break;
                }
                case f: {
                    var10000 = fbc.g;
                    break;
                }
                case y: {
                    var10000 = fbc.y;
                    break;
                }
                case e: {
                    var10000 = fbc.z;
                    break;
                }
                default: {
                    var10000 = EntityNodeEvaluator.checkNeighbourBlocks(var0, var2, var3, var4, fbc.c);
                }
            }
            return var10000;
        }
        return var5;
    }
}

