/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R6.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import java.lang.invoke.MethodHandle;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.citizensnpcs.util.NMS;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagDataPack;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityTypes;

public class CustomEntityRegistry
extends DefaultedMappedRegistry<EntityTypes<?>>
implements Supplier<RegistryMaterials<EntityTypes<?>>> {
    private final Holder.c<EntityTypes<?>> defaultReference;
    private final BiMap<MinecraftKey, Holder.c<EntityTypes<?>>> entities = HashBiMap.create();
    private final BiMap<Holder.c<EntityTypes<?>>, MinecraftKey> entityClasses = this.entities.inverse();
    private final Map<EntityTypes, Integer> entityIds = Maps.newHashMap();
    private final RegistryMaterials<EntityTypes<?>> wrapped;
    private static final MethodHandle IREGISTRY_LIFECYCLE = NMS.getFirstGetter(RegistryMaterials.class, Lifecycle.class);
    private static final MethodHandle IREGISTRY_RESOURCE_KEY = NMS.getFirstGetter(RegistryMaterials.class, ResourceKey.class);

    public CustomEntityRegistry(RegistryBlocks<EntityTypes<?>> original) throws Throwable {
        super(original.b().b(), IREGISTRY_RESOURCE_KEY.invoke(original), IREGISTRY_LIFECYCLE.invoke(original), true);
        this.defaultReference = EntityTypes.aV.r();
        this.wrapped = (RegistryMaterials)original;
    }

    public IRegistry<Holder<EntityTypes<?>>> t() {
        return this.wrapped.t();
    }

    public void o() {
        this.wrapped.o();
    }

    public void a(TagKey<EntityTypes<?>> tag, List<Holder<EntityTypes<?>>> list) {
        this.wrapped.a(tag, list);
    }

    public EntityTypes byId(int var0) {
        return (EntityTypes)this.wrapped.a(var0);
    }

    public EntityTypes byIdOrThrow(int var0) {
        return (EntityTypes)this.wrapped.b(var0);
    }

    public boolean a(HolderOwner<EntityTypes<?>> owner) {
        return this.wrapped.a(owner);
    }

    public boolean e(ResourceKey<EntityTypes<?>> var0) {
        return this.wrapped.e(var0);
    }

    public boolean d(MinecraftKey var0) {
        return this.wrapped.d(var0);
    }

    public Holder.c<EntityTypes<?>> createIntrusiveHolder(EntityTypes<?> type) {
        return this.wrapped.f(type);
    }

    public HolderGetter<EntityTypes<?>> p() {
        return this.wrapped.p();
    }

    public Set<Map.Entry<ResourceKey<EntityTypes<?>>, EntityTypes<?>>> k() {
        return this.wrapped.k();
    }

    public IRegistry<EntityTypes<?>> n() {
        return this.wrapped.n();
    }

    @Override
    public RegistryMaterials<EntityTypes<?>> get() {
        return this.wrapped;
    }

    public Optional<Holder.c<EntityTypes<?>>> a(ResourceKey<EntityTypes<?>> key) {
        return this.wrapped.a(key);
    }

    public Optional<Holder.c<EntityTypes<?>>> c(MinecraftKey key) {
        if (this.entities.containsKey((Object)key)) {
            return Optional.ofNullable((Holder.c)this.entities.get((Object)key));
        }
        return this.wrapped.c(key);
    }

    public Optional<HolderSet.Named<EntityTypes<?>>> a(TagKey<EntityTypes<?>> key) {
        return this.wrapped.a(key);
    }

    public Optional<Holder.c<EntityTypes<?>>> a() {
        return this.wrapped.a();
    }

    public int getId(EntityTypes<?> key) {
        if (this.entityIds.containsKey(key)) {
            return this.entityIds.get(key);
        }
        return this.wrapped.a(key);
    }

    public MinecraftKey getKey(EntityTypes<?> value) {
        return this.wrapped.b(value);
    }

    public Optional<EntityTypes<?>> f(ResourceKey<EntityTypes<?>> var0) {
        return this.wrapped.f(var0);
    }

    public Optional<EntityTypes<?>> b(MinecraftKey var0) {
        if (this.entities.containsKey((Object)var0)) {
            return Optional.ofNullable(this.getValue(var0));
        }
        return this.wrapped.b(var0);
    }

    public Optional<Holder.c<EntityTypes<?>>> a(RandomSource paramRandom) {
        return this.wrapped.a(paramRandom);
    }

    public Optional<ResourceKey<EntityTypes<?>>> getResourceKey(EntityTypes<?> var0) {
        return this.wrapped.d(var0);
    }

    public Stream<HolderSet.Named<EntityTypes<?>>> l() {
        return this.wrapped.l();
    }

    public EntityTypes<?> getValue(ResourceKey<EntityTypes<?>> key) {
        return (EntityTypes)this.wrapped.c(key);
    }

    public EntityTypes<?> getValue(MinecraftKey key) {
        if (this.entities.containsKey((Object)key)) {
            return (EntityTypes)((Holder.c)this.entities.getOrDefault((Object)key, this.defaultReference)).a();
        }
        return (EntityTypes)this.wrapped.a(key);
    }

    public Codec<Holder<EntityTypes<?>>> r() {
        return this.wrapped.r();
    }

    public boolean m() {
        return this.wrapped.m();
    }

    public Iterator<EntityTypes<?>> iterator() {
        return this.wrapped.iterator();
    }

    public ResourceKey<? extends IRegistry<EntityTypes<?>>> g() {
        return this.wrapped.g();
    }

    public Set<MinecraftKey> i() {
        return this.wrapped.i();
    }

    public Stream<Holder.c<EntityTypes<?>>> c() {
        return this.wrapped.c();
    }

    public Stream<HolderSet.Named<EntityTypes<?>>> e() {
        return this.wrapped.e();
    }

    public IRegistry.a<EntityTypes<?>> a(TagDataPack.c<EntityTypes<?>> var0) {
        return this.wrapped.a(var0);
    }

    public void put(int entityId, MinecraftKey key, EntityTypes entityClass) {
        this.entities.put((Object)key, (Object)entityClass.r());
        this.entityIds.put(entityClass, entityId);
    }

    public Optional<RegistrationInfo> d(ResourceKey<EntityTypes<?>> key) {
        return this.wrapped.d(key);
    }

    public Set<ResourceKey<EntityTypes<?>>> j() {
        return this.wrapped.j();
    }

    public Lifecycle h() {
        return this.wrapped.h();
    }

    public int d() {
        return this.wrapped.d();
    }

    public String toString() {
        return this.wrapped.toString();
    }

    public Holder<EntityTypes<?>> wrapAsHolder(EntityTypes<?> type) {
        return this.wrapped.e(type);
    }
}

