/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R7.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R7.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R7.util.NMSImpl;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.inventory.ItemStack;

public class FallingBlockController
extends AbstractEntityController {
    protected Entity createEntity(Location at, NPC npc) {
        WorldServer ws = ((CraftWorld)at.getWorld()).getHandle();
        Block id = CraftMagicNumbers.getBlock((Material)((ItemStack)npc.getItemProvider().get()).getType());
        EntityFallingBlockNPC handle = new EntityFallingBlockNPC((EntityTypes<? extends EntityFallingBlock>)EntityTypes.ab, (World)ws, npc);
        handle.a_(at.getX(), at.getY(), at.getZ());
        handle.k(Vec3D.c);
        NMSImpl.setFallingBlockState(handle, id.m());
        return handle.getBukkitEntity();
    }

    public FallingBlock getBukkitEntity() {
        return (FallingBlock)super.getBukkitEntity();
    }

    public static class EntityFallingBlockNPC
    extends EntityFallingBlock
    implements NPCHolder {
        private final CitizensNPC npc;
        private static final double EPSILON = 0.001;

        public EntityFallingBlockNPC(EntityTypes<? extends EntityFallingBlock> types, World level) {
            this(types, level, null);
        }

        public EntityFallingBlockNPC(EntityTypes<? extends EntityFallingBlock> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new FallingBlockNPC(this));
            }
            return super.getBukkitEntity();
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction n_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.n_();
        }

        public boolean bY() {
            return this.npc == null ? super.bY() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.c(vec3));
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void j_() {
            if (this.npc == null) {
                super.j_();
            } else {
                NMSImpl.setSize((net.minecraft.world.entity.Entity)this, this.ay);
            }
        }

        public boolean c(ValueOutput save) {
            return this.npc == null ? super.c(save) : false;
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null || transition.b().aq().equals(this.ao().aq())) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void g() {
            if (this.npc != null) {
                this.npc.update();
                Vec3D mot = this.dN();
                if (Math.abs(mot.g) > 0.001 || Math.abs(mot.h) > 0.001 || Math.abs(mot.i) > 0.001) {
                    mot = mot.d(0.98, 0.98, 0.98);
                    this.k(mot);
                    this.a(EnumMoveType.a, mot);
                }
            } else {
                super.g();
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dN().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.k(old);
            }
            return res;
        }
    }

    public static class FallingBlockNPC
    extends CraftFallingBlock
    implements NPCHolder {
        private final CitizensNPC npc;

        public FallingBlockNPC(EntityFallingBlockNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityFallingBlock)entity);
            this.npc = entity.npc;
        }

        public NPC getNPC() {
            return this.npc;
        }
    }
}

