/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.NPCNeedsRespawnEvent;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.CommandSenderCreateNPCEvent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.EntityTargetNPCEvent;
import net.citizensnpcs.api.event.NPCCombustByBlockEvent;
import net.citizensnpcs.api.event.NPCCombustByEntityEvent;
import net.citizensnpcs.api.event.NPCCombustEvent;
import net.citizensnpcs.api.event.NPCDamageByBlockEvent;
import net.citizensnpcs.api.event.NPCDamageByEntityEvent;
import net.citizensnpcs.api.event.NPCDamageEntityEvent;
import net.citizensnpcs.api.event.NPCDamageEvent;
import net.citizensnpcs.api.event.NPCDeathEvent;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCLeftClickEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.event.PlayerCreateNPCEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public class EventListen
implements Listener {
    private final NPCRegistry npcRegistry = CitizensAPI.getNPCRegistry();
    private final Map<String, NPCRegistry> registries;
    private final ListMultimap<ChunkCoord, NPC> toRespawn = ArrayListMultimap.create();

    EventListen(Map<String, NPCRegistry> registries) {
        this.registries = registries;
    }

    private void checkCreationEvent(CommandSenderCreateNPCEvent event) {
        int maxChecks;
        if (event.getCreator().hasPermission("citizens.admin.avoid-limits")) {
            return;
        }
        int limit = Settings.Setting.DEFAULT_NPC_LIMIT.asInt();
        for (int i = maxChecks = Settings.Setting.MAX_NPC_LIMIT_CHECKS.asInt(); i >= 0; --i) {
            if (!event.getCreator().hasPermission("citizens.npc.limit." + i)) continue;
            limit = i;
            break;
        }
        if (limit < 0) {
            return;
        }
        int owned = 0;
        for (NPC npc : this.npcRegistry) {
            if (event.getNPC().equals(npc) || !npc.hasTrait(Owner.class) || !npc.getTrait(Owner.class).isOwnedBy(event.getCreator())) continue;
            ++owned;
        }
        int wouldOwn = owned + 1;
        if (wouldOwn > limit) {
            event.setCancelled(true);
            event.setCancelReason(Messaging.tr("citizens.limits.over-npc-limit", limit));
        }
    }

    private Iterable<NPC> getAllNPCs() {
        return Iterables.filter((Iterable)Iterables.concat((Iterable)this.npcRegistry, (Iterable)Iterables.concat(this.registries.values())), (Predicate)Predicates.notNull());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChunkLoad(ChunkLoadEvent event) {
        this.respawnAllFromCoord(this.toCoord(event.getChunk()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChunkUnload(ChunkUnloadEvent event) {
        ChunkCoord coord = this.toCoord(event.getChunk());
        Location loc = new Location(null, 0.0, 0.0, 0.0);
        for (NPC npc : this.getAllNPCs()) {
            if (npc == null || !npc.isSpawned()) continue;
            loc = npc.getEntity().getLocation(loc);
            boolean sameChunkCoordinates = coord.z == loc.getBlockZ() >> 4 && coord.x == loc.getBlockX() >> 4;
            if (!sameChunkCoordinates || !event.getWorld().equals(loc.getWorld())) continue;
            if (!npc.despawn(DespawnReason.CHUNK_UNLOAD)) {
                event.setCancelled(true);
                if (Messaging.isDebugging()) {
                    Messaging.debug("Cancelled chunk unload at [" + coord.x + "," + coord.z + "]");
                }
                this.respawnAllFromCoord(coord);
                return;
            }
            this.toRespawn.put((Object)coord, (Object)npc);
            if (!Messaging.isDebugging()) continue;
            Messaging.debug("Despawned id", npc.getId(), "due to chunk unload at [" + coord.x + "," + coord.z + "]");
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCommandSenderCreateNPC(CommandSenderCreateNPCEvent event) {
        this.checkCreationEvent(event);
    }

    @EventHandler
    public void onEntityCombust(EntityCombustEvent event) {
        NPC npc = this.npcRegistry.getNPC(event.getEntity());
        if (npc == null) {
            return;
        }
        event.setCancelled(npc.data().get("protected", true).booleanValue());
        if (event instanceof EntityCombustByEntityEvent) {
            Bukkit.getPluginManager().callEvent((Event)new NPCCombustByEntityEvent((EntityCombustByEntityEvent)event, npc));
        } else if (event instanceof EntityCombustByBlockEvent) {
            Bukkit.getPluginManager().callEvent((Event)new NPCCombustByBlockEvent((EntityCombustByBlockEvent)event, npc));
        } else {
            Bukkit.getPluginManager().callEvent((Event)new NPCCombustEvent(event, npc));
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        NPC npc = this.npcRegistry.getNPC(event.getEntity());
        if (npc == null) {
            if (event instanceof EntityDamageByEntityEvent) {
                npc = this.npcRegistry.getNPC(((EntityDamageByEntityEvent)event).getDamager());
                if (npc == null) {
                    return;
                }
                event.setCancelled(npc.data().get("damage-others", true) == false);
                NPCDamageEntityEvent damageEvent = new NPCDamageEntityEvent(npc, (EntityDamageByEntityEvent)event);
                Bukkit.getPluginManager().callEvent((Event)damageEvent);
            }
            return;
        }
        event.setCancelled(npc.data().get("protected", true).booleanValue());
        if (event instanceof EntityDamageByEntityEvent) {
            NPCDamageByEntityEvent damageEvent = new NPCDamageByEntityEvent(npc, (EntityDamageByEntityEvent)event);
            Bukkit.getPluginManager().callEvent((Event)damageEvent);
            if (!damageEvent.isCancelled() || !(damageEvent.getDamager() instanceof Player)) {
                return;
            }
            Player damager = (Player)damageEvent.getDamager();
            NPCLeftClickEvent leftClickEvent = new NPCLeftClickEvent(npc, damager);
            Bukkit.getPluginManager().callEvent((Event)leftClickEvent);
        } else if (event instanceof EntityDamageByBlockEvent) {
            Bukkit.getPluginManager().callEvent((Event)new NPCDamageByBlockEvent(npc, (EntityDamageByBlockEvent)event));
        } else {
            Bukkit.getPluginManager().callEvent((Event)new NPCDamageEvent(npc, event));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        final NPC npc = this.npcRegistry.getNPC((Entity)event.getEntity());
        if (npc == null) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCDeathEvent(npc, event));
        final Location location = npc.getEntity().getLocation();
        npc.despawn(DespawnReason.DEATH);
        if (npc.data().get("respawn-delay", -1) >= 0) {
            int delay = npc.data().get("respawn-delay", -1);
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    if (!npc.isSpawned()) {
                        npc.spawn(location);
                    }
                }
            }, (long)(delay + 2));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntitySpawn(CreatureSpawnEvent event) {
        if (event.isCancelled() && this.npcRegistry.isNPC((Entity)event.getEntity())) {
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onEntityTarget(EntityTargetEvent event) {
        NPC npc = this.npcRegistry.getNPC(event.getTarget());
        if (npc == null) {
            return;
        }
        event.setCancelled(npc.data().get("protected-target", npc.data().get("protected", true) == false) == false);
        Bukkit.getPluginManager().callEvent((Event)new EntityTargetNPCEvent(event, npc));
    }

    @EventHandler
    public void onNeedsRespawn(NPCNeedsRespawnEvent event) {
        ChunkCoord coord = this.toCoord(event.getSpawnLocation());
        if (this.toRespawn.containsEntry((Object)coord, (Object)event.getNPC())) {
            return;
        }
        this.toRespawn.put((Object)coord, (Object)event.getNPC());
    }

    @EventHandler
    public void onNPCDespawn(NPCDespawnEvent event) {
        if ((event.getReason() == DespawnReason.PLUGIN || event.getReason() == DespawnReason.REMOVAL) && event.getNPC().getStoredLocation() != null) {
            this.toRespawn.remove((Object)this.toCoord(event.getNPC().getStoredLocation()), (Object)event.getNPC());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        if (!(event.getPlayer() instanceof NPCHolder)) {
            return;
        }
        NMS.removeFromServerPlayerList(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCreateNPC(PlayerCreateNPCEvent event) {
        this.checkCreationEvent(event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        NPC npc = this.npcRegistry.getNPC(event.getRightClicked());
        if (npc == null) {
            return;
        }
        Player player = event.getPlayer();
        NPCRightClickEvent rightClickEvent = new NPCRightClickEvent(npc, player);
        Bukkit.getPluginManager().callEvent((Event)rightClickEvent);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        NPC npc;
        Editor.leave(event.getPlayer());
        if (event.getPlayer().isInsideVehicle() && (npc = this.npcRegistry.getNPC(event.getPlayer().getVehicle())) != null) {
            event.getPlayer().leaveVehicle();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onVehicleEnter(VehicleEnterEvent event) {
        if (!this.npcRegistry.isNPC(event.getEntered())) {
            return;
        }
        NPC npc = this.npcRegistry.getNPC(event.getEntered());
        if (npc.getEntity().getType() == EntityType.HORSE && !npc.getTrait(Controllable.class).isEnabled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onWorldLoad(WorldLoadEvent event) {
        for (ChunkCoord chunk : this.toRespawn.keySet()) {
            if (!chunk.worldName.equals(event.getWorld().getName()) || !event.getWorld().isChunkLoaded(chunk.x, chunk.z)) continue;
            this.respawnAllFromCoord(chunk);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldUnload(WorldUnloadEvent event) {
        for (NPC npc : this.getAllNPCs()) {
            if (npc == null || !npc.isSpawned() || !npc.getEntity().getWorld().equals(event.getWorld())) continue;
            boolean despawned = npc.despawn(DespawnReason.WORLD_UNLOAD);
            if (event.isCancelled() || !despawned) {
                for (ChunkCoord coord : this.toRespawn.keySet()) {
                    if (!event.getWorld().getName().equals(coord.worldName)) continue;
                    this.respawnAllFromCoord(coord);
                }
                return;
            }
            this.storeForRespawn(npc);
            Messaging.debug("Despawned", npc.getId() + "due to world unload at", event.getWorld().getName());
        }
    }

    private void respawnAllFromCoord(ChunkCoord coord) {
        List ids = this.toRespawn.get((Object)coord);
        for (int i = 0; i < ids.size(); ++i) {
            NPC npc = (NPC)ids.get(i);
            boolean success = this.spawn(npc);
            if (!success) {
                if (!Messaging.isDebugging()) continue;
                Messaging.debug("Couldn't respawn id", npc.getId(), "during chunk event at [" + coord.x + "," + coord.z + "]");
                continue;
            }
            ids.remove(i--);
            if (!Messaging.isDebugging()) continue;
            Messaging.debug("Spawned id", npc.getId(), "due to chunk event at [" + coord.x + "," + coord.z + "]");
        }
    }

    private boolean spawn(NPC npc) {
        Location spawn = npc.getTrait(CurrentLocation.class).getLocation();
        if (spawn == null) {
            if (Messaging.isDebugging()) {
                Messaging.debug("Couldn't find a spawn location for despawned NPC id", npc.getId());
            }
            return false;
        }
        return npc.spawn(spawn);
    }

    private void storeForRespawn(NPC npc) {
        this.toRespawn.put((Object)this.toCoord(npc.getEntity().getLocation()), (Object)npc);
    }

    private ChunkCoord toCoord(Chunk chunk) {
        return new ChunkCoord(chunk);
    }

    private ChunkCoord toCoord(Location loc) {
        return new ChunkCoord(loc.getWorld().getName(), loc.getBlockX() >> 4, loc.getBlockZ() >> 4);
    }

    private static class ChunkCoord {
        private final String worldName;
        private final int x;
        private final int z;

        private ChunkCoord(Chunk chunk) {
            this(chunk.getWorld().getName(), chunk.getX(), chunk.getZ());
        }

        private ChunkCoord(String worldName, int x, int z) {
            this.x = x;
            this.z = z;
            this.worldName = worldName;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ChunkCoord other = (ChunkCoord)obj;
            if (this.worldName == null ? other.worldName != null : !this.worldName.equals(other.worldName)) {
                return false;
            }
            return this.x == other.x && this.z == other.z;
        }

        public int hashCode() {
            int prime = 31;
            return 31 * (31 * (31 + (this.worldName == null ? 0 : this.worldName.hashCode())) + this.x) + this.z;
        }
    }
}

