/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import java.util.Arrays;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.ItemStorage;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.inventory.ItemStack;

public class Inventory
extends Trait {
    private ItemStack[] contents = new ItemStack[36];

    public Inventory() {
        super("inventory");
    }

    public ItemStack[] getContents() {
        return this.contents;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.contents = this.parseContents(key);
    }

    @Override
    public void onSpawn() {
        switch (this.npc.getEntity().getType()) {
            case PLAYER: {
                ((Player)this.npc.getEntity()).getInventory().setContents(this.contents);
                break;
            }
            case MINECART: {
                if (!(this.npc.getEntity() instanceof StorageMinecart)) break;
                ((StorageMinecart)this.npc.getEntity()).getInventory().setContents(Arrays.copyOf(this.contents, this.contents.length * 2));
                break;
            }
        }
    }

    private ItemStack[] parseContents(DataKey key) throws NPCLoadException {
        ItemStack[] contents = new ItemStack[36];
        for (DataKey slotKey : key.getIntegerSubKeys()) {
            contents[Integer.parseInt((String)slotKey.name())] = ItemStorage.loadItemStack(slotKey);
        }
        return contents;
    }

    @Override
    public void run() {
        if (this.npc.getEntity() instanceof Player) {
            this.contents = ((Player)this.npc.getEntity()).getInventory().getContents();
        }
    }

    @Override
    public void save(DataKey key) {
        int slot = 0;
        for (ItemStack item : this.contents) {
            key.removeKey(String.valueOf(slot));
            if (item != null) {
                ItemStorage.saveItem(key.getRelative(String.valueOf(slot)), item);
            }
            ++slot;
        }
    }

    public void setContents(ItemStack[] contents) {
        this.contents = contents;
    }

    public String toString() {
        return "Inventory{" + Arrays.toString(this.contents) + "}";
    }
}

