/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import net.citizensnpcs.Settings;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.astar.AStarMachine;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.ChunkBlockSource;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.astar.pathfinder.VectorGoal;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.ai.AbstractPathStrategy;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_7_R4.Entity;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class AStarNavigationStrategy
extends AbstractPathStrategy {
    private final Location destination;
    private final NPC npc;
    private final NavigatorParameters params;
    private Path plan;
    private Vector vector;
    private static final AStarMachine<VectorNode, Path> ASTAR = AStarMachine.createWithDefaultStorage();
    private static final Location NPC_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    AStarNavigationStrategy(NPC npc, Location dest, NavigatorParameters params) {
        super(TargetType.LOCATION);
        this.params = params;
        this.destination = dest;
        this.npc = npc;
        Location location = Util.getEyeLocation(npc.getEntity());
        VectorGoal goal = new VectorGoal(dest, (float)params.pathDistanceMargin());
        this.plan = ASTAR.runFully(goal, new VectorNode(goal, location, (BlockSource)new ChunkBlockSource(location, params.range()), params.examiners()), 50000);
        if (this.plan == null || this.plan.isComplete()) {
            this.setCancelReason(CancelReason.STUCK);
        } else {
            this.vector = this.plan.getCurrentVector();
            if (Settings.Setting.DEBUG_PATHFINDING.asBoolean()) {
                this.plan.debug();
            }
        }
    }

    @Override
    public Location getTargetAsLocation() {
        return this.destination;
    }

    @Override
    public void stop() {
        if (this.plan != null && Settings.Setting.DEBUG_PATHFINDING.asBoolean()) {
            this.plan.debugEnd();
        }
        this.plan = null;
    }

    @Override
    public boolean update() {
        if (this.getCancelReason() != null || this.plan == null || this.plan.isComplete()) {
            return true;
        }
        if (this.npc.getEntity().getLocation(NPC_LOCATION).toVector().distanceSquared(this.vector) <= this.params.distanceMargin()) {
            this.plan.update(this.npc);
            if (this.plan.isComplete()) {
                return true;
            }
            this.vector = this.plan.getCurrentVector();
        }
        Entity handle = NMS.getHandle(this.npc.getEntity());
        double dX = (double)this.vector.getBlockX() - handle.locX;
        double dZ = (double)this.vector.getBlockZ() - handle.locZ;
        double dY = this.vector.getY() - handle.locY;
        double xzDistance = dX * dX + dZ * dZ;
        double distance = xzDistance + dY * dY;
        if (Settings.Setting.DEBUG_PATHFINDING.asBoolean()) {
            this.npc.getEntity().getWorld().playEffect(this.vector.toLocation(this.npc.getEntity().getWorld()), Effect.ENDER_SIGNAL, 0);
        }
        if (distance > 0.0 && dY > 0.0 && dY < 1.0 && xzDistance <= 2.75) {
            NMS.setShouldJump(this.npc.getEntity());
        }
        double destX = this.vector.getX() + 0.5;
        double destZ = this.vector.getZ() + 0.5;
        NMS.setDestination(this.npc.getEntity(), destX, this.vector.getY(), destZ, this.params.speed());
        this.params.run();
        this.plan.run(this.npc);
        return false;
    }
}

