/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.MobEntityController;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_7_R4.Entity;
import net.minecraft.server.v1_7_R4.EntityCaveSpider;
import net.minecraft.server.v1_7_R4.EntityLiving;
import net.minecraft.server.v1_7_R4.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftCaveSpider;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;
import org.bukkit.entity.CaveSpider;
import org.bukkit.util.Vector;

public class CaveSpiderController
extends MobEntityController {
    public CaveSpiderController() {
        super(EntityCaveSpiderNPC.class);
    }

    public CaveSpider getBukkitEntity() {
        return (CaveSpider)super.getBukkitEntity();
    }

    public static class EntityCaveSpiderNPC
    extends EntityCaveSpider
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityCaveSpiderNPC(World world) {
            this(world, null);
        }

        public EntityCaveSpiderNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        protected void a(double d0, boolean flag) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag);
            }
        }

        protected String aT() {
            return this.npc == null ? super.aT() : this.npc.data().get("hurt-sound", super.aT());
        }

        protected String aU() {
            return this.npc == null ? super.aU() : this.npc.data().get("death-sound", super.aU());
        }

        protected void b(float f) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.b(f);
            }
        }

        public boolean bN() {
            if (this.npc == null) {
                return super.bN();
            }
            boolean protectedDefault = this.npc.data().get("protected", true);
            if (!protectedDefault || !this.npc.data().get("protected-leash", protectedDefault).booleanValue()) {
                return super.bN();
            }
            if (super.bN()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void bn() {
            super.bn();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public void bq() {
            if (this.npc == null) {
                super.bq();
            } else {
                NMS.updateAI((EntityLiving)this);
                this.npc.update();
            }
        }

        public void collide(Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
            }
        }

        public void e(float f, float f1) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.e(f, f1);
            } else {
                NMS.flyingMoveLogic((EntityLiving)this, f, f1);
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new CaveSpiderNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean h_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.h_();
            }
            return false;
        }

        protected String t() {
            return this.npc == null || !this.npc.data().has("ambient-sound") ? super.t() : this.npc.data().get("ambient-sound", super.t());
        }

        protected void w() {
            if (this.npc == null) {
                super.w();
            }
        }
    }

    public static class CaveSpiderNPC
    extends CraftCaveSpider
    implements NPCHolder {
        private final CitizensNPC npc;

        public CaveSpiderNPC(EntityCaveSpiderNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityCaveSpider)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

