/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.MobEntityController;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.HorseModifiers;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_7_R4.Entity;
import net.minecraft.server.v1_7_R4.EntityHorse;
import net.minecraft.server.v1_7_R4.EntityLiving;
import net.minecraft.server.v1_7_R4.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftHorse;
import org.bukkit.entity.Horse;
import org.bukkit.util.Vector;

public class HorseController
extends MobEntityController {
    public HorseController() {
        super(EntityHorseNPC.class);
    }

    public Horse getBukkitEntity() {
        return (Horse)super.getBukkitEntity();
    }

    @Override
    public void spawn(Location at, NPC npc) {
        npc.getTrait(HorseModifiers.class);
        super.spawn(at, npc);
    }

    public static class HorseNPC
    extends CraftHorse
    implements NPCHolder {
        private final CitizensNPC npc;

        public HorseNPC(EntityHorseNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityHorse)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EntityHorseNPC
    extends EntityHorse
    implements NPCHolder {
        private int jumpTicks;
        private final CitizensNPC npc;

        public EntityHorseNPC(World world) {
            this(world, null);
        }

        public EntityHorseNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
                ((Horse)this.getBukkitEntity()).setDomestication(((Horse)this.getBukkitEntity()).getMaxDomestication());
            }
        }

        public void a(boolean flag) {
            float oldw = this.width;
            float oldl = this.length;
            super.a(flag);
            if (oldw != this.width || oldl != this.length) {
                this.setPosition(this.locX - 0.01, this.locY, this.locZ - 0.01);
                this.setPosition(this.locX + 0.01, this.locY, this.locZ + 0.01);
            }
        }

        protected void a(double d0, boolean flag) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag);
            }
        }

        protected String aT() {
            return this.npc == null ? super.aT() : this.npc.data().get("hurt-sound", super.aT());
        }

        protected String aU() {
            return this.npc == null ? super.aU() : this.npc.data().get("death-sound", super.aU());
        }

        protected void b(float f) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.b(f);
            }
        }

        public boolean bN() {
            if (this.npc == null) {
                return super.bN();
            }
            boolean protectedDefault = this.npc.data().get("protected", true);
            if (!protectedDefault || !this.npc.data().get("protected-leash", protectedDefault).booleanValue()) {
                return super.bN();
            }
            if (super.bN()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void collide(Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
            }
        }

        public void e() {
            if (this.npc == null) {
                super.e();
            } else {
                NMS.setStepHeight((EntityLiving)this, 1.0f);
                this.updateAIWithMovement();
                this.npc.update();
            }
        }

        public void e(float f, float f1) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.e(f, f1);
            } else {
                NMS.flyingMoveLogic((EntityLiving)this, f, f1);
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new HorseNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean h_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.h_();
            }
            return false;
        }

        protected String t() {
            return this.npc == null || !this.npc.data().has("ambient-sound") ? super.t() : this.npc.data().get("ambient-sound", super.t());
        }

        private void updateAIWithMovement() {
            NMS.updateAI((EntityLiving)this);
            if (this.bc) {
                if (this.onGround && this.jumpTicks == 0) {
                    this.bj();
                    this.jumpTicks = 10;
                }
            } else {
                this.jumpTicks = 0;
            }
            this.bd *= 0.98f;
            this.be *= 0.98f;
            this.bf *= 0.9f;
            this.e(this.bd, this.be);
            NMS.setHeadYaw((Entity)this, this.yaw);
            if (this.jumpTicks > 0) {
                --this.jumpTicks;
            }
        }

        protected void w() {
            if (this.npc == null) {
                super.w();
            }
        }
    }
}

