/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingDeque;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Colorizer;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.entity.EntityHumanNPC;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_7_R4.PlayerInteractManager;
import net.minecraft.server.v1_7_R4.World;
import net.minecraft.server.v1_7_R4.WorldServer;
import net.minecraft.util.com.google.common.collect.Iterables;
import net.minecraft.util.com.google.common.collect.Multimap;
import net.minecraft.util.com.mojang.authlib.Agent;
import net.minecraft.util.com.mojang.authlib.GameProfile;
import net.minecraft.util.com.mojang.authlib.GameProfileRepository;
import net.minecraft.util.com.mojang.authlib.HttpAuthenticationService;
import net.minecraft.util.com.mojang.authlib.ProfileLookupCallback;
import net.minecraft.util.com.mojang.authlib.minecraft.MinecraftSessionService;
import net.minecraft.util.com.mojang.authlib.properties.Property;
import net.minecraft.util.com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import net.minecraft.util.com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import net.minecraft.util.com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import net.minecraft.util.com.mojang.util.UUIDTypeAdapter;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class HumanController
extends AbstractEntityController {
    private static final String CACHED_SKIN_UUID_METADATA = "cached-skin-uuid";
    private static final String CACHED_SKIN_UUID_NAME_METADATA = "cached-skin-uuid-name";
    private static Method MAKE_REQUEST;
    private static SkinThread SKIN_THREAD;
    private static final Map<String, Property> TEXTURE_CACHE;
    private static final Map<String, String> UUID_CACHE;

    public HumanController() {
        if (SKIN_THREAD == null) {
            SKIN_THREAD = new SkinThread();
            Bukkit.getScheduler().runTaskTimerAsynchronously(CitizensAPI.getPlugin(), (Runnable)SKIN_THREAD, 10L, 10L);
        }
    }

    @Override
    protected Entity createEntity(Location at, final NPC npc) {
        UUID uuid;
        WorldServer nmsWorld = ((CraftWorld)at.getWorld()).getHandle();
        String coloredName = Colorizer.parseColors(npc.getFullName());
        if (coloredName.length() > 16) {
            coloredName = coloredName.substring(0, 16);
        }
        if ((uuid = npc.getUniqueId()).version() == 4) {
            uuid = new UUID(uuid.getMostSignificantBits() | 0x5000L, uuid.getLeastSignificantBits());
        }
        GameProfile profile = new GameProfile(uuid, coloredName);
        this.updateSkin(npc, nmsWorld, profile);
        EntityHumanNPC handle = new EntityHumanNPC(nmsWorld.getServer().getServer(), nmsWorld, profile, new PlayerInteractManager((World)nmsWorld), npc);
        handle.setPositionRotation(at.getX(), at.getY(), at.getZ(), at.getYaw(), at.getPitch());
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                boolean removeFromPlayerList = Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean();
                NMS.addOrRemoveFromPlayerList((Entity)HumanController.this.getBukkitEntity(), npc.data().get("removefromplayerlist", removeFromPlayerList));
            }
        }, 1L);
        handle.getBukkitEntity().setSleepingIgnored(true);
        return handle.getBukkitEntity();
    }

    public Player getBukkitEntity() {
        return (Player)super.getBukkitEntity();
    }

    private void updateSkin(NPC npc, WorldServer nmsWorld, GameProfile profile) {
        Property cached;
        String skinUUID = (String)npc.data().get("player-skin-name");
        if (skinUUID == null) {
            skinUUID = npc.getName();
        }
        if (npc.data().has(CACHED_SKIN_UUID_METADATA) && npc.data().has(CACHED_SKIN_UUID_NAME_METADATA) && ChatColor.stripColor((String)skinUUID).equalsIgnoreCase(ChatColor.stripColor((String)((String)npc.data().get(CACHED_SKIN_UUID_NAME_METADATA))))) {
            skinUUID = (String)npc.data().get(CACHED_SKIN_UUID_METADATA);
        }
        if ((cached = TEXTURE_CACHE.get(skinUUID)) != null) {
            profile.getProperties().put((Object)"textures", (Object)cached);
        } else {
            SKIN_THREAD.addRunnable(new SkinFetcher(new UUIDFetcher(skinUUID, npc), nmsWorld.getMinecraftServer().av(), npc));
        }
    }

    static {
        TEXTURE_CACHE = Maps.newConcurrentMap();
        UUID_CACHE = Maps.newConcurrentMap();
        try {
            MAKE_REQUEST = YggdrasilAuthenticationService.class.getDeclaredMethod("makeRequest", URL.class, Object.class, Class.class);
            MAKE_REQUEST.setAccessible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class UUIDFetcher
    implements Callable<String> {
        private final NPC npc;
        private String reportedUUID;

        public UUIDFetcher(String reportedUUID, NPC npc) {
            this.reportedUUID = reportedUUID;
            this.npc = npc;
        }

        @Override
        public String call() throws Exception {
            String skinUUID = (String)UUID_CACHE.get(this.reportedUUID);
            if (skinUUID != null) {
                this.reportedUUID = skinUUID;
            }
            if (this.reportedUUID.contains("-")) {
                return this.reportedUUID;
            }
            GameProfileRepository repo = ((CraftServer)Bukkit.getServer()).getServer().getGameProfileRepository();
            repo.findProfilesByNames(new String[]{ChatColor.stripColor((String)this.reportedUUID)}, Agent.MINECRAFT, new ProfileLookupCallback(){

                public void onProfileLookupFailed(GameProfile arg0, Exception arg1) {
                    throw new RuntimeException(arg1);
                }

                public void onProfileLookupSucceeded(GameProfile profile) {
                    UUID_CACHE.put(UUIDFetcher.this.reportedUUID, profile.getId().toString());
                    UUIDFetcher.this.npc.data().setPersistent(HumanController.CACHED_SKIN_UUID_METADATA, profile.getId().toString());
                    UUIDFetcher.this.npc.data().setPersistent(HumanController.CACHED_SKIN_UUID_NAME_METADATA, profile.getName());
                }
            });
            return this.npc.data().get(HumanController.CACHED_SKIN_UUID_METADATA, this.reportedUUID);
        }
    }

    public static class SkinThread
    implements Runnable {
        private volatile int delay = 0;
        private final BlockingDeque<Runnable> tasks = new LinkedBlockingDeque<Runnable>();

        public void addRunnable(Runnable r) {
            this.tasks.offer(r);
        }

        public void delay() {
            this.delay = 120;
        }

        @Override
        public void run() {
            if (this.delay != 0) {
                --this.delay;
                return;
            }
            Runnable r = (Runnable)this.tasks.pollFirst();
            if (r == null) {
                return;
            }
            r.run();
        }
    }

    private static class SkinFetcher
    implements Runnable {
        private final NPC npc;
        private final MinecraftSessionService repo;
        private final Callable<String> uuid;

        public SkinFetcher(Callable<String> uuid, MinecraftSessionService repo, NPC npc) {
            this.uuid = uuid;
            this.repo = repo;
            this.npc = npc;
        }

        private GameProfile fillProfileProperties(YggdrasilAuthenticationService auth, GameProfile profile, boolean requireSecure) throws Exception {
            URL url = HttpAuthenticationService.constantURL((String)("https://sessionserver.mojang.com/session/minecraft/profile/" + UUIDTypeAdapter.fromUUID((UUID)profile.getId())));
            url = HttpAuthenticationService.concatenateURL((URL)url, (String)("unsigned=" + !requireSecure));
            MinecraftProfilePropertiesResponse response = (MinecraftProfilePropertiesResponse)MAKE_REQUEST.invoke((Object)auth, url, null, MinecraftProfilePropertiesResponse.class);
            if (response == null) {
                return profile;
            }
            GameProfile result = new GameProfile(response.getId(), response.getName());
            result.getProperties().putAll((Multimap)response.getProperties());
            profile.getProperties().putAll((Multimap)response.getProperties());
            return result;
        }

        @Override
        public void run() {
            String realUUID;
            try {
                realUUID = this.uuid.call();
            }
            catch (Exception e) {
                return;
            }
            GameProfile skinProfile = null;
            Property cached = (Property)TEXTURE_CACHE.get(realUUID);
            if (cached != null) {
                skinProfile = new GameProfile(UUID.fromString(realUUID), "");
                skinProfile.getProperties().put((Object)"textures", (Object)cached);
            } else {
                try {
                    skinProfile = this.fillProfileProperties(((YggdrasilMinecraftSessionService)this.repo).getAuthenticationService(), new GameProfile(UUID.fromString(realUUID), ""), true);
                }
                catch (Exception e) {
                    if (e.getMessage() != null && e.getMessage().contains("too many requests")) {
                        SKIN_THREAD.delay();
                        SKIN_THREAD.addRunnable(this);
                    }
                    return;
                }
                if (skinProfile == null || !skinProfile.getProperties().containsKey((Object)"textures")) {
                    return;
                }
                Property textures = (Property)Iterables.getFirst((Iterable)skinProfile.getProperties().get((Object)"textures"), null);
                if (textures.getValue() == null || textures.getSignature() == null) {
                    return;
                }
                TEXTURE_CACHE.put(realUUID, new Property("textures", textures.getValue(), textures.getSignature()));
            }
            Bukkit.getScheduler().callSyncMethod(CitizensAPI.getPlugin(), (Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    if (SkinFetcher.this.npc.isSpawned()) {
                        SkinFetcher.this.npc.despawn(DespawnReason.PENDING_RESPAWN);
                        SkinFetcher.this.npc.spawn(SkinFetcher.this.npc.getStoredLocation());
                    }
                    return null;
                }
            });
        }
    }
}

