/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity.nonliving;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_7_R4.Entity;
import net.minecraft.server.v1_7_R4.EntityEgg;
import net.minecraft.server.v1_7_R4.World;
import net.minecraft.server.v1_7_R4.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEgg;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;
import org.bukkit.entity.Egg;
import org.bukkit.util.Vector;

public class EggController
extends AbstractEntityController {
    public EggController() {
        super(EntityEggNPC.class);
    }

    @Override
    protected org.bukkit.entity.Entity createEntity(Location at, NPC npc) {
        WorldServer ws = ((CraftWorld)at.getWorld()).getHandle();
        EntityEggNPC handle = new EntityEggNPC((World)ws, npc, at.getX(), at.getY(), at.getZ());
        return handle.getBukkitEntity();
    }

    public Egg getBukkitEntity() {
        return (Egg)super.getBukkitEntity();
    }

    public static class EntityEggNPC
    extends EntityEgg
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEggNPC(World world) {
            this(world, null);
        }

        public EntityEggNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
        }

        public EntityEggNPC(World world, NPC npc, double d0, double d1, double d2) {
            super(world, d0, d1, d2);
            this.npc = (CitizensNPC)npc;
        }

        public void collide(Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new EggNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void h() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.h();
            }
        }
    }

    public static class EggNPC
    extends CraftEgg
    implements NPCHolder {
        private final CitizensNPC npc;

        public EggNPC(EntityEggNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityEgg)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

