/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity.nonliving;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.MobEntityController;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_7_R4.Entity;
import net.minecraft.server.v1_7_R4.EntityExperienceOrb;
import net.minecraft.server.v1_7_R4.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftExperienceOrb;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.util.Vector;

public class ExperienceOrbController
extends MobEntityController {
    public ExperienceOrbController() {
        super(EntityExperienceOrbNPC.class);
    }

    public ExperienceOrb getBukkitEntity() {
        return (ExperienceOrb)super.getBukkitEntity();
    }

    public static class ExperienceOrbNPC
    extends CraftExperienceOrb
    implements NPCHolder {
        private final CitizensNPC npc;

        public ExperienceOrbNPC(EntityExperienceOrbNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityExperienceOrb)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EntityExperienceOrbNPC
    extends EntityExperienceOrb
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityExperienceOrbNPC(World world) {
            this(world, null);
        }

        public EntityExperienceOrbNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
        }

        public void collide(Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new ExperienceOrbNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void h() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.h();
            }
        }
    }
}

