/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity.nonliving;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.MobEntityController;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_7_R4.Entity;
import net.minecraft.server.v1_7_R4.EntityMinecartAbstract;
import net.minecraft.server.v1_7_R4.EntityMinecartChest;
import net.minecraft.server.v1_7_R4.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftMinecartChest;
import org.bukkit.entity.Minecart;
import org.bukkit.util.Vector;

public class MinecartChestController
extends MobEntityController {
    public MinecartChestController() {
        super(EntityMinecartChestNPC.class);
    }

    public Minecart getBukkitEntity() {
        return (Minecart)super.getBukkitEntity();
    }

    public static class MinecartChestNPC
    extends CraftMinecartChest
    implements NPCHolder {
        private final CitizensNPC npc;

        public MinecartChestNPC(EntityMinecartChestNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityMinecartChest)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EntityMinecartChestNPC
    extends EntityMinecartChest
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityMinecartChestNPC(World world) {
            this(world, null);
        }

        public EntityMinecartChestNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
        }

        public void collide(Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new MinecartChestNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void h() {
            if (this.npc != null) {
                this.npc.update();
                NMS.minecartItemLogic((EntityMinecartAbstract)this);
            } else {
                super.h();
            }
        }
    }
}

