/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalSelector;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.ai.event.NavigatorCallback;
import net.citizensnpcs.api.astar.AStarGoal;
import net.citizensnpcs.api.astar.AStarMachine;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.Agent;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.prtree.DistanceResult;
import net.citizensnpcs.api.util.prtree.PRTree;
import net.citizensnpcs.api.util.prtree.Region3D;
import net.citizensnpcs.api.util.prtree.SimplePointND;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointEditor;
import net.citizensnpcs.trait.waypoint.WaypointMarkers;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.Vector;

public class GuidedWaypointProvider
implements WaypointProvider {
    private final List<Waypoint> available = Lists.newArrayList();
    private GuidedAIGoal currentGoal;
    private final List<Waypoint> helpers = Lists.newArrayList();
    private NPC npc;
    private boolean paused;
    private PRTree<Region3D<Waypoint>> tree = PRTree.create(new Region3D.Converter(), 30);
    private static final AStarMachine<GuidedNode, GuidedPlan> ASTAR = AStarMachine.createWithDefaultStorage();

    @Override
    public WaypointEditor createEditor(CommandSender sender, CommandContext args) {
        if (!(sender instanceof Player)) {
            Messaging.sendErrorTr(sender, "citizens.commands.requirements.must-be-ingame", new Object[0]);
            return null;
        }
        final Player player = (Player)sender;
        return new WaypointEditor(){
            private final WaypointMarkers markers;
            private boolean showPath;
            {
                this.markers = new WaypointMarkers(player.getWorld());
            }

            @Override
            public void begin() {
                this.showPath();
                Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.guided.begin", new Object[0]);
            }

            private void createWaypointMarkers() {
                for (Waypoint waypoint : Iterables.concat((Iterable)GuidedWaypointProvider.this.available, (Iterable)GuidedWaypointProvider.this.helpers)) {
                    this.markers.createWaypointMarker(waypoint);
                }
            }

            private void createWaypointMarkerWithData(Waypoint element) {
                Entity entity = this.markers.createWaypointMarker(element);
                if (entity == null) {
                    return;
                }
                entity.setMetadata("citizens.waypointhashcode", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)element.hashCode()));
            }

            @Override
            public void end() {
                Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.guided.end", new Object[0]);
                this.markers.destroyWaypointMarkers();
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerChat(AsyncPlayerChatEvent event) {
                if (event.getMessage().equalsIgnoreCase("toggle path")) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            this.togglePath();
                        }
                    });
                }
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerInteract(PlayerInteractEvent event) {
                if (!event.getPlayer().equals(player) || event.getAction() == Action.PHYSICAL || event.getClickedBlock() == null) {
                    return;
                }
                if (event.getPlayer().getWorld() != GuidedWaypointProvider.this.npc.getEntity().getWorld()) {
                    return;
                }
                event.setCancelled(true);
                Location at = event.getClickedBlock().getLocation();
                Waypoint element = new Waypoint(at);
                if (player.isSneaking()) {
                    GuidedWaypointProvider.this.available.add(element);
                    Messaging.send((CommandSender)player, "citizens.editors.waypoints.guided.added-available");
                } else {
                    GuidedWaypointProvider.this.helpers.add(element);
                    Messaging.send((CommandSender)player, "citizens.editors.waypoints.guided.added-guide");
                }
                this.createWaypointMarkerWithData(element);
                GuidedWaypointProvider.this.rebuildTree();
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
                if (!event.getRightClicked().hasMetadata("citizens.waypointhashcode")) {
                    return;
                }
                int hashcode = ((MetadataValue)event.getRightClicked().getMetadata("citizens.waypointhashcode").get(0)).asInt();
                Iterator itr = Iterables.concat((Iterable)GuidedWaypointProvider.this.available, (Iterable)GuidedWaypointProvider.this.helpers).iterator();
                while (itr.hasNext()) {
                    if (((Waypoint)itr.next()).hashCode() != hashcode) continue;
                    itr.remove();
                    break;
                }
            }

            private void showPath() {
                for (Waypoint element : Iterables.concat((Iterable)GuidedWaypointProvider.this.available, (Iterable)GuidedWaypointProvider.this.helpers)) {
                    this.createWaypointMarkerWithData(element);
                }
            }

            private void togglePath() {
                boolean bl = this.showPath = !this.showPath;
                if (this.showPath) {
                    this.createWaypointMarkers();
                    Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.linear.showing-markers", new Object[0]);
                } else {
                    this.markers.destroyWaypointMarkers();
                    Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.linear.not-showing-markers", new Object[0]);
                }
            }
        };
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void load(DataKey key) {
        Waypoint waypoint;
        for (DataKey root : key.getRelative("availablewaypoints").getIntegerSubKeys()) {
            waypoint = (Waypoint)((Object)PersistenceLoader.load(Waypoint.class, root));
            if (waypoint == null) continue;
            this.available.add(waypoint);
        }
        for (DataKey root : key.getRelative("helperwaypoints").getIntegerSubKeys()) {
            waypoint = (Waypoint)((Object)PersistenceLoader.load(Waypoint.class, root));
            if (waypoint == null) continue;
            this.helpers.add(waypoint);
        }
        this.rebuildTree();
    }

    @Override
    public void onRemove() {
        this.npc.getDefaultGoalController().removeGoal(this.currentGoal);
    }

    @Override
    public void onSpawn(NPC npc) {
        this.npc = npc;
        if (this.currentGoal == null) {
            this.currentGoal = new GuidedAIGoal();
            CitizensAPI.registerEvents(this.currentGoal);
            npc.getDefaultGoalController().addGoal(this.currentGoal, 1);
        }
    }

    private void rebuildTree() {
        this.tree = PRTree.create(new Region3D.Converter(), 30);
        this.tree.load(Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.concat(this.available, this.helpers), (Function)new Function<Waypoint, Region3D<Waypoint>>(){

            public Region3D<Waypoint> apply(Waypoint arg0) {
                Location loc = arg0.getLocation();
                Vector root = new Vector(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
                return new Region3D<Waypoint>(root, root, arg0);
            }
        })));
    }

    @Override
    public void save(DataKey key) {
        int i;
        key.removeKey("availablewaypoints");
        DataKey root = key.getRelative("availablewaypoints");
        for (i = 0; i < this.available.size(); ++i) {
            PersistenceLoader.save(this.available.get(i), root.getRelative(i));
        }
        key.removeKey("helperwaypoints");
        root = key.getRelative("helperwaypoints");
        for (i = 0; i < this.helpers.size(); ++i) {
            PersistenceLoader.save(this.helpers.get(i), root.getRelative(i));
        }
    }

    @Override
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    private static class GuidedPlan
    implements Plan {
        private int index = 0;
        private final Waypoint[] path;

        public GuidedPlan(Iterable<GuidedNode> path) {
            this.path = (Waypoint[])Iterables.toArray((Iterable)Iterables.transform(path, (Function)new Function<GuidedNode, Waypoint>(){

                public Waypoint apply(GuidedNode to) {
                    return to.waypoint;
                }
            }), Waypoint.class);
        }

        public Waypoint getCurrentWaypoint() {
            return this.path[this.index];
        }

        @Override
        public boolean isComplete() {
            return this.index >= this.path.length;
        }

        @Override
        public void update(Agent agent) {
            ++this.index;
        }
    }

    private class GuidedNode
    extends AStarNode {
        private final Waypoint waypoint;

        public GuidedNode(Waypoint waypoint) {
            this.waypoint = waypoint;
        }

        @Override
        public Plan buildPlan() {
            return new GuidedPlan(this.getParents());
        }

        public double distance(Waypoint dest) {
            return this.waypoint.distance(dest);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            GuidedNode other = (GuidedNode)obj;
            return !(this.waypoint == null ? other.waypoint != null : !this.waypoint.equals(other.waypoint));
        }

        @Override
        public Iterable<AStarNode> getNeighbours() {
            List res = GuidedWaypointProvider.this.tree.nearestNeighbour(Region3D.distanceCalculator(), Region3D.alwaysAcceptNodeFilter(), 15, new SimplePointND(this.waypoint.getLocation().getBlockX(), this.waypoint.getLocation().getBlockY(), this.waypoint.getLocation().getBlockZ()));
            return Iterables.transform(res, (Function)new Function<DistanceResult<Region3D<Waypoint>>, AStarNode>(){

                public AStarNode apply(DistanceResult<Region3D<Waypoint>> arg0) {
                    return new GuidedNode(arg0.get().getData());
                }
            });
        }

        @Override
        public int hashCode() {
            return 31 + (this.waypoint == null ? 0 : this.waypoint.hashCode());
        }
    }

    private static class GuidedGoal
    implements AStarGoal<GuidedNode> {
        private final Waypoint dest;

        public GuidedGoal(Waypoint dest) {
            this.dest = dest;
        }

        @Override
        public float g(GuidedNode from, GuidedNode to) {
            return (float)from.distance(to.waypoint);
        }

        @Override
        public float getInitialCost(GuidedNode node) {
            return this.h(node);
        }

        @Override
        public float h(GuidedNode from) {
            return (float)from.distance(this.dest);
        }

        @Override
        public boolean isFinished(GuidedNode node) {
            return node.waypoint.equals(this.dest);
        }
    }

    private class GuidedAIGoal
    implements Goal {
        private GuidedPlan plan;

        private GuidedAIGoal() {
        }

        @Override
        public void reset() {
            this.plan = null;
        }

        @Override
        public void run(GoalSelector selector) {
            if (this.plan.isComplete()) {
                selector.finish();
                return;
            }
            if (GuidedWaypointProvider.this.npc.getNavigator().isNavigating()) {
                return;
            }
            Waypoint current = this.plan.getCurrentWaypoint();
            GuidedWaypointProvider.this.npc.getNavigator().setTarget(current.getLocation());
            GuidedWaypointProvider.this.npc.getNavigator().getLocalParameters().addSingleUseCallback(new NavigatorCallback(){

                @Override
                public void onCompletion(CancelReason cancelReason) {
                    GuidedAIGoal.this.plan.update(GuidedWaypointProvider.this.npc);
                }
            });
        }

        @Override
        public boolean shouldExecute(GoalSelector selector) {
            if (GuidedWaypointProvider.this.paused || GuidedWaypointProvider.this.available.size() == 0 || !GuidedWaypointProvider.this.npc.isSpawned() || GuidedWaypointProvider.this.npc.getNavigator().isNavigating()) {
                return false;
            }
            Waypoint target = (Waypoint)GuidedWaypointProvider.this.available.get(Util.getFastRandom().nextInt(GuidedWaypointProvider.this.available.size()));
            this.plan = (GuidedPlan)ASTAR.runFully(new GuidedGoal(target), new GuidedNode(new Waypoint(GuidedWaypointProvider.this.npc.getStoredLocation())));
            return this.plan != null;
        }
    }
}

