/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api;

import java.io.File;
import net.citizensnpcs.api.npc.NPCManager;
import net.citizensnpcs.api.npc.character.CharacterManager;
import net.citizensnpcs.api.scripting.ScriptCompiler;
import net.citizensnpcs.api.trait.TraitManager;

public final class CitizensAPI {
    private CharacterManager characterManager;
    private File dataFolder;
    private NPCManager npcManager;
    private final ScriptCompiler scriptCompiler = new ScriptCompiler();
    private TraitManager traitManager;
    private static final CitizensAPI instance = new CitizensAPI();

    private CitizensAPI() {
        new Thread(this.scriptCompiler).start();
    }

    public static File getScriptFolder() {
        return new File(CitizensAPI.instance.dataFolder, "scripts");
    }

    public static CharacterManager getCharacterManager() {
        return CitizensAPI.instance.characterManager;
    }

    public static File getDataFolder() {
        return CitizensAPI.instance.dataFolder;
    }

    public static NPCManager getNPCManager() {
        return CitizensAPI.instance.npcManager;
    }

    public static ScriptCompiler getScriptCompiler() {
        return CitizensAPI.instance.scriptCompiler;
    }

    public static TraitManager getTraitManager() {
        return CitizensAPI.instance.traitManager;
    }

    public static void setCharacterManager(CharacterManager characterManager) {
        if (CitizensAPI.instance.characterManager == null) {
            CitizensAPI.instance.characterManager = characterManager;
        }
    }

    public static void setDataFolder(File file) {
        if (CitizensAPI.instance.dataFolder == null) {
            CitizensAPI.instance.dataFolder = file;
        }
    }

    public static void setNPCManager(NPCManager npcManager) {
        if (CitizensAPI.instance.npcManager == null) {
            CitizensAPI.instance.npcManager = npcManager;
        }
    }

    public static void setTraitManager(TraitManager traitManager) {
        if (CitizensAPI.instance.traitManager == null) {
            CitizensAPI.instance.traitManager = traitManager;
        }
    }
}

