/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import net.citizensnpcs.api.util.DatabaseStorage;

public enum DatabaseType {
    H2("org.h2.Driver"),
    MYSQL("com.mysql.jdbc.Driver"),
    POSTGRE("org.postgresql.Driver"),
    SQLITE("org.sqlite.JDBC"){

        @Override
        public String[] prepareForeignKeySQL(DatabaseStorage.Table from, DatabaseStorage.Table to, String columnName) {
            return new String[]{String.format("ALTER TABLE `%s` ADD COLUMN `%s` %s REFERENCES `%s`(`%s`) ON DELETE CASCADE", from.name, columnName, to.primaryKeyType, to.name, to.primaryKey)};
        }
    };

    private final String driver;
    private boolean loaded = false;

    private DatabaseType(String driver) {
        this.driver = driver;
    }

    public String[] prepareForeignKeySQL(DatabaseStorage.Table from, DatabaseStorage.Table to, String columnName) {
        String[] sql = new String[]{String.format("ALTER TABLE `%s` ADD `%s` %s", from.name, columnName, to.primaryKeyType), String.format("ALTER TABLE `%s` ADD FOREIGN KEY (`%s`) REFERENCES `%s`(`%s`) ON DELETE CASCADE", from.name, columnName, to.name, to.primaryKey)};
        return sql;
    }

    public boolean load() {
        if (this.loaded) {
            return true;
        }
        if (DatabaseStorage.loadDriver(DatabaseStorage.class.getClassLoader(), this.driver)) {
            this.loaded = true;
        }
        return this.loaded;
    }

    public static DatabaseType match(String driver) {
        for (DatabaseType type : DatabaseType.values()) {
            if (!type.name().toLowerCase().contains(driver)) continue;
            return type;
        }
        return null;
    }
}

