/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Map;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.PathStrategy;
import net.citizensnpcs.npc.entity.EntityHumanNPC;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.Navigation;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class MCNavigationStrategy
implements PathStrategy {
    private EntityHumanNPC entity = null;
    private final Navigation navigation;
    private static final float DEFAULT_SPEED = 0.3f;
    private static final Map<EntityType, Float> MOVEMENT_SPEEDS = Maps.newEnumMap(EntityType.class);
    private static Field SPEED_FIELD;

    MCNavigationStrategy(CitizensNPC npc, Location dest) {
        if (npc.getBukkitEntity() instanceof Player) {
            this.entity = (EntityHumanNPC)npc.getHandle();
            this.entity.onGround = true;
        }
        this.navigation = npc.getHandle().al();
        this.navigation.a(dest.getX(), dest.getY(), dest.getZ(), this.getSpeed(npc.getHandle()));
    }

    MCNavigationStrategy(EntityLiving entity, EntityLiving target) {
        if (entity instanceof EntityHumanNPC) {
            this.entity = (EntityHumanNPC)entity;
            entity.onGround = true;
        }
        this.navigation = entity.al();
        this.navigation.a(target, this.getSpeed(entity));
    }

    private float getSpeed(EntityLiving from) {
        Float cached = MOVEMENT_SPEEDS.get(from.getBukkitEntity().getType());
        if (cached != null) {
            return cached.floatValue();
        }
        if (SPEED_FIELD == null) {
            MOVEMENT_SPEEDS.put(from.getBukkitEntity().getType(), Float.valueOf(0.3f));
            return 0.3f;
        }
        try {
            float speed = SPEED_FIELD.getFloat(from);
            MOVEMENT_SPEEDS.put(from.getBukkitEntity().getType(), Float.valueOf(speed));
            return speed;
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return 0.3f;
        }
    }

    @Override
    public boolean update() {
        if (this.entity != null) {
            this.navigation.d();
            this.entity.moveOnCurrentHeading();
        }
        return this.navigation.e();
    }

    static {
        MOVEMENT_SPEEDS.put(EntityType.IRON_GOLEM, Float.valueOf(0.15f));
        MOVEMENT_SPEEDS.put(EntityType.CHICKEN, Float.valueOf(0.25f));
        MOVEMENT_SPEEDS.put(EntityType.COW, Float.valueOf(0.2f));
        MOVEMENT_SPEEDS.put(EntityType.SHEEP, Float.valueOf(0.25f));
        MOVEMENT_SPEEDS.put(EntityType.VILLAGER, Float.valueOf(0.3f));
        MOVEMENT_SPEEDS.put(EntityType.SNOWMAN, Float.valueOf(0.25f));
        try {
            SPEED_FIELD = EntityLiving.class.getDeclaredField("bb");
            SPEED_FIELD.setAccessible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

