/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.command;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.command.Command;
import net.citizensnpcs.command.CommandContext;
import net.citizensnpcs.command.Injector;
import net.citizensnpcs.command.Requirements;
import net.citizensnpcs.command.ServerCommand;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.command.exception.CommandUsageException;
import net.citizensnpcs.command.exception.NoPermissionsException;
import net.citizensnpcs.command.exception.RequirementMissingException;
import net.citizensnpcs.command.exception.ServerCommandException;
import net.citizensnpcs.command.exception.UnhandledCommandException;
import net.citizensnpcs.command.exception.WrappedCommandException;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class CommandManager {
    private final Map<String, Method> commands = new HashMap<String, Method>();
    private Injector injector;
    private final Map<Method, Object> instances = new HashMap<Method, Object>();
    private final Map<Method, Requirements> requirements = new HashMap<Method, Requirements>();
    private final Map<Method, ServerCommand> serverCommands = new HashMap<Method, ServerCommand>();
    private final Map<String, List<Command>> subCommands = new HashMap<String, List<Command>>();
    private static final Logger logger = Logger.getLogger(CommandManager.class.getCanonicalName());

    public void execute(String cmd, String[] args, Player player, Object ... methodArgs) throws CommandException {
        String[] newArgs = new String[args.length + 1];
        System.arraycopy(args, 0, newArgs, 1, args.length);
        newArgs[0] = cmd;
        Object[] newMethodArgs = new Object[methodArgs.length + 1];
        System.arraycopy(methodArgs, 0, newMethodArgs, 1, methodArgs.length);
        this.executeMethod(null, newArgs, player, newMethodArgs);
    }

    public void execute(String[] args, Player player, Object ... methodArgs) throws CommandException {
        Object[] newMethodArgs = new Object[methodArgs.length + 1];
        System.arraycopy(methodArgs, 0, newMethodArgs, 1, methodArgs.length);
        this.executeMethod(null, args, player, newMethodArgs);
    }

    public void executeMethod(Method parent, String[] args, Player player, Object[] methodArgs) throws CommandException {
        Requirements cmdRequirements;
        String cmdName = args[0];
        String modifier = args.length > 1 ? args[1] : "";
        Method method = this.commands.get(cmdName.toLowerCase() + " " + modifier.toLowerCase());
        if (method == null) {
            method = this.commands.get(cmdName.toLowerCase() + " *");
        }
        if (method != null && methodArgs != null && this.serverCommands.get(method) == null && methodArgs[1] instanceof ConsoleCommandSender) {
            throw new ServerCommandException();
        }
        if (method == null && parent == null) {
            throw new UnhandledCommandException();
        }
        if (methodArgs[1] instanceof Player && !this.hasPermission(method, player)) {
            throw new NoPermissionsException();
        }
        if (methodArgs[1] instanceof Player && (cmdRequirements = this.requirements.get(method)) != null) {
            NPC npc = (NPC)methodArgs[2];
            if (cmdRequirements.selected() && npc == null) {
                throw new RequirementMissingException("You must have an NPC selected to execute that command.");
            }
            if (cmdRequirements.ownership() && npc != null && !npc.getTrait(Owner.class).getOwner().equals(player.getName()) && !player.hasPermission("citizens.admin")) {
                throw new RequirementMissingException("You must be the owner of this NPC to execute that command.");
            }
            if (npc != null) {
                EnumSet<EntityType> types = Sets.newEnumSet(Arrays.asList(cmdRequirements.types()), EntityType.class);
                if (types.contains(EntityType.UNKNOWN)) {
                    types = EnumSet.allOf(EntityType.class);
                }
                types.removeAll(Sets.newHashSet((Object[])cmdRequirements.excludedTypes()));
                EntityType type = EntityType.valueOf((String)npc.getTrait(MobType.class).getType());
                if (!types.contains(type)) {
                    throw new RequirementMissingException("The NPC cannot be the mob type '" + type.name().toLowerCase().replace('_', '-') + "' to use that command.");
                }
            }
        }
        Command cmd = method.getAnnotation(Command.class);
        CommandContext context = new CommandContext(args);
        if (context.argsLength() < cmd.min()) {
            throw new CommandUsageException("Too few arguments.", this.getUsage(args, cmd));
        }
        if (cmd.max() != -1 && context.argsLength() > cmd.max()) {
            throw new CommandUsageException("Too many arguments.", this.getUsage(args, cmd));
        }
        for (char flag : context.getFlags()) {
            if (cmd.flags().indexOf(String.valueOf(flag)) != -1) continue;
            throw new CommandUsageException("Unknown flag: " + flag, this.getUsage(args, cmd));
        }
        methodArgs[0] = context;
        Object instance = this.instances.get(method);
        try {
            method.invoke(instance, methodArgs);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE, "Failed to execute command", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "Failed to execute command", e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CommandException) {
                throw (CommandException)e.getCause();
            }
            throw new WrappedCommandException(e.getCause());
        }
    }

    public String[] getAllCommandModifiers(String command) {
        HashSet<String> cmds = new HashSet<String>();
        for (String cmd : this.commands.keySet()) {
            String[] split = cmd.split(" ");
            if (!split[0].equalsIgnoreCase(command) || split.length <= 1) continue;
            cmds.add(split[1]);
        }
        return cmds.toArray(new String[cmds.size()]);
    }

    public List<Command> getCommands(String command) {
        if (this.subCommands.containsKey(command)) {
            return this.subCommands.get(command);
        }
        ArrayList<Command> cmds = new ArrayList<Command>();
        for (Map.Entry<String, Method> entry : this.commands.entrySet()) {
            if (!entry.getKey().split(" ")[0].equalsIgnoreCase(command) || !entry.getValue().isAnnotationPresent(Command.class)) continue;
            cmds.add(entry.getValue().getAnnotation(Command.class));
        }
        return cmds;
    }

    private String getUsage(String[] args, Command cmd) {
        StringBuilder command = new StringBuilder();
        command.append("/");
        command.append(args[0] + " ");
        command.append(cmd.usage());
        return command.toString();
    }

    public boolean hasCommand(String command, String modifier) {
        return this.commands.containsKey(command.toLowerCase() + " " + modifier.toLowerCase()) || this.commands.containsKey(command.toLowerCase() + " *");
    }

    private boolean hasPermission(Method method, Player player) {
        Command cmd = method.getAnnotation(Command.class);
        return cmd.permission().isEmpty() || this.hasPermission(player, cmd.permission()) || this.hasPermission(player, "admin");
    }

    private boolean hasPermission(Player player, String perm) {
        return player.hasPermission("citizens." + perm);
    }

    public void register(Class<?> clazz) {
        this.registerMethods(clazz, null);
    }

    private void registerMethods(Class<?> clazz, Method parent) {
        Object obj = this.injector.getInstance(clazz);
        this.registerMethods(clazz, parent, obj);
    }

    private void registerMethods(Class<?> clazz, Method parent, Object obj) {
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(Command.class)) continue;
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            Command cmd = method.getAnnotation(Command.class);
            for (String alias : cmd.aliases()) {
                for (String modifier : cmd.modifiers()) {
                    this.commands.put(alias + " " + modifier, method);
                }
            }
            Requirements cmdRequirements = null;
            if (method.getDeclaringClass().isAnnotationPresent(Requirements.class)) {
                cmdRequirements = method.getDeclaringClass().getAnnotation(Requirements.class);
            }
            if (method.isAnnotationPresent(Requirements.class)) {
                cmdRequirements = method.getAnnotation(Requirements.class);
            }
            if (this.requirements != null) {
                this.requirements.put(method, cmdRequirements);
            }
            ServerCommand serverCommand = null;
            if (method.isAnnotationPresent(ServerCommand.class)) {
                serverCommand = method.getAnnotation(ServerCommand.class);
            }
            if (serverCommand != null) {
                this.serverCommands.put(method, serverCommand);
            }
            if (isStatic || obj == null) continue;
            this.instances.put(method, obj);
        }
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }
}

