/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.PathStrategy;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet18ArmAnimation;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;

public class MCTargetStrategy
implements PathStrategy {
    private final boolean aggro;
    private final EntityLiving handle;
    private final EntityLiving target;
    private static final double ATTACK_DISTANCE = 3.0625;

    public MCTargetStrategy(CitizensNPC handle, LivingEntity target, boolean aggro) {
        this.handle = handle.getHandle();
        this.target = ((CraftLivingEntity)target).getHandle();
        this.aggro = aggro;
    }

    private boolean canAttack() {
        return this.handle.attackTicks == 0 && this.handle.boundingBox.e > this.target.boundingBox.b && this.handle.boundingBox.b < this.target.boundingBox.e && this.distanceSquared() <= 3.0625 && this.handle.h((Entity)this.target);
    }

    private double distanceSquared() {
        return this.handle.getBukkitEntity().getLocation().distanceSquared(this.target.getBukkitEntity().getLocation());
    }

    @Override
    public boolean update() {
        if (this.target == null || this.target.dead) {
            return true;
        }
        new MCNavigationStrategy(this.handle, this.target).update();
        this.handle.getControllerLook().a((Entity)this.target, 10.0f, (float)this.handle.D());
        if (this.aggro && this.canAttack()) {
            if (this.handle instanceof EntityMonster) {
                ((EntityMonster)this.handle).a((Entity)this.target);
            } else if (this.handle instanceof EntityPlayer) {
                EntityPlayer humanHandle = (EntityPlayer)this.handle;
                humanHandle.attack((Entity)this.target);
                humanHandle.netServerHandler.sendPacket((Packet)new Packet18ArmAnimation((Entity)humanHandle, 1));
            }
        }
        return false;
    }
}

