/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.event.NPCSelectEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCManager;
import net.citizensnpcs.api.npc.character.Character;
import net.citizensnpcs.api.util.Storage;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHandle;
import net.citizensnpcs.npc.entity.CitizensBlazeNPC;
import net.citizensnpcs.npc.entity.CitizensCaveSpiderNPC;
import net.citizensnpcs.npc.entity.CitizensChickenNPC;
import net.citizensnpcs.npc.entity.CitizensCowNPC;
import net.citizensnpcs.npc.entity.CitizensCreeperNPC;
import net.citizensnpcs.npc.entity.CitizensEnderDragonNPC;
import net.citizensnpcs.npc.entity.CitizensEndermanNPC;
import net.citizensnpcs.npc.entity.CitizensGhastNPC;
import net.citizensnpcs.npc.entity.CitizensGiantNPC;
import net.citizensnpcs.npc.entity.CitizensHumanNPC;
import net.citizensnpcs.npc.entity.CitizensIronGolemNPC;
import net.citizensnpcs.npc.entity.CitizensMagmaCubeNPC;
import net.citizensnpcs.npc.entity.CitizensMushroomCowNPC;
import net.citizensnpcs.npc.entity.CitizensOcelotNPC;
import net.citizensnpcs.npc.entity.CitizensPigNPC;
import net.citizensnpcs.npc.entity.CitizensPigZombieNPC;
import net.citizensnpcs.npc.entity.CitizensSheepNPC;
import net.citizensnpcs.npc.entity.CitizensSilverfishNPC;
import net.citizensnpcs.npc.entity.CitizensSkeletonNPC;
import net.citizensnpcs.npc.entity.CitizensSlimeNPC;
import net.citizensnpcs.npc.entity.CitizensSnowmanNPC;
import net.citizensnpcs.npc.entity.CitizensSpiderNPC;
import net.citizensnpcs.npc.entity.CitizensSquidNPC;
import net.citizensnpcs.npc.entity.CitizensVillagerNPC;
import net.citizensnpcs.npc.entity.CitizensWolfNPC;
import net.citizensnpcs.npc.entity.CitizensZombieNPC;
import net.citizensnpcs.util.ByIdArray;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class CitizensNPCManager
implements NPCManager {
    private final ByIdArray<NPC> npcs = new ByIdArray();
    private final Citizens plugin;
    private final Storage saves;
    private final Map<EntityType, Class<? extends CitizensNPC>> types = new EnumMap<EntityType, Class<? extends CitizensNPC>>(EntityType.class);

    public CitizensNPCManager(Citizens plugin, Storage saves) {
        this.plugin = plugin;
        this.saves = saves;
        this.types.put(EntityType.BLAZE, CitizensBlazeNPC.class);
        this.types.put(EntityType.CAVE_SPIDER, CitizensCaveSpiderNPC.class);
        this.types.put(EntityType.CHICKEN, CitizensChickenNPC.class);
        this.types.put(EntityType.COW, CitizensCowNPC.class);
        this.types.put(EntityType.CREEPER, CitizensCreeperNPC.class);
        this.types.put(EntityType.ENDER_DRAGON, CitizensEnderDragonNPC.class);
        this.types.put(EntityType.ENDERMAN, CitizensEndermanNPC.class);
        this.types.put(EntityType.GHAST, CitizensGhastNPC.class);
        this.types.put(EntityType.GIANT, CitizensGiantNPC.class);
        this.types.put(EntityType.IRON_GOLEM, CitizensIronGolemNPC.class);
        this.types.put(EntityType.MAGMA_CUBE, CitizensMagmaCubeNPC.class);
        this.types.put(EntityType.MUSHROOM_COW, CitizensMushroomCowNPC.class);
        this.types.put(EntityType.OCELOT, CitizensOcelotNPC.class);
        this.types.put(EntityType.PIG, CitizensPigNPC.class);
        this.types.put(EntityType.PIG_ZOMBIE, CitizensPigZombieNPC.class);
        this.types.put(EntityType.PLAYER, CitizensHumanNPC.class);
        this.types.put(EntityType.SHEEP, CitizensSheepNPC.class);
        this.types.put(EntityType.SILVERFISH, CitizensSilverfishNPC.class);
        this.types.put(EntityType.SKELETON, CitizensSkeletonNPC.class);
        this.types.put(EntityType.SLIME, CitizensSlimeNPC.class);
        this.types.put(EntityType.SNOWMAN, CitizensSnowmanNPC.class);
        this.types.put(EntityType.SPIDER, CitizensSpiderNPC.class);
        this.types.put(EntityType.SQUID, CitizensSquidNPC.class);
        this.types.put(EntityType.VILLAGER, CitizensVillagerNPC.class);
        this.types.put(EntityType.WOLF, CitizensWolfNPC.class);
        this.types.put(EntityType.ZOMBIE, CitizensZombieNPC.class);
    }

    public NPC createNPC(EntityType type, int id, String name, Character character) {
        CitizensNPC npc = this.getByType(type, id, name);
        if (npc == null) {
            throw new IllegalStateException("Could not create NPC.");
        }
        if (character != null) {
            npc.setCharacter(character);
        }
        this.npcs.put(npc.getId(), npc);
        return npc;
    }

    @Override
    public NPC createNPC(EntityType type, String name) {
        return this.createNPC(type, name, null);
    }

    @Override
    public NPC createNPC(EntityType type, String name, Character character) {
        return this.createNPC(type, this.generateUniqueId(), name, character);
    }

    private int generateUniqueId() {
        int count = 0;
        while (this.getNPC(count++) != null) {
        }
        return count - 1;
    }

    @Override
    public NPC getNPC(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        net.minecraft.server.Entity handle = ((CraftEntity)entity).getHandle();
        if (handle instanceof NPCHandle) {
            return ((NPCHandle)handle).getNPC();
        }
        return null;
    }

    @Override
    public NPC getNPC(int id) {
        return this.npcs.get(id);
    }

    @Override
    public Collection<NPC> getNPCs(Class<? extends Character> character) {
        ArrayList<NPC> npcs = new ArrayList<NPC>();
        for (NPC npc : this) {
            if (npc.getCharacter() == null || !npc.getCharacter().getClass().equals(character)) continue;
            npcs.add(npc);
        }
        return npcs;
    }

    @Override
    public boolean isNPC(Entity entity) {
        return this.getNPC(entity) != null;
    }

    @Override
    public Iterator<NPC> iterator() {
        return this.npcs.iterator();
    }

    void remove(NPC npc) {
        this.npcs.remove(npc.getId());
        this.removeData(npc);
    }

    public void removeAll() {
        Iterator<NPC> itr = this.iterator();
        while (itr.hasNext()) {
            NPC npc = itr.next();
            npc.despawn();
            this.removeData(npc);
            itr.remove();
        }
    }

    private void removeData(NPC npc) {
        this.saves.getKey("npc").removeKey(String.valueOf(npc.getId()));
        this.removeMetadata(npc);
    }

    private void removeMetadata(NPC npc) {
        if (npc.hasMetadata("selectors")) {
            for (MetadataValue value : npc.getMetadata("selectors")) {
                Player search = Bukkit.getPlayerExact((String)value.asString());
                if (search == null) continue;
                search.removeMetadata("selected", (Plugin)this.plugin);
            }
            npc.removeMetadata("selectors", this.plugin);
        }
    }

    public void safeRemove() {
        Iterator<NPC> itr = this.iterator();
        while (itr.hasNext()) {
            NPC npc = itr.next();
            itr.remove();
            this.removeMetadata(npc);
            npc.despawn();
        }
    }

    public void selectNPC(Player player, NPC npc) {
        if (player.hasMetadata("selected")) {
            player.removeMetadata("selected", (Plugin)this.plugin);
        }
        player.setMetadata("selected", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)npc.getId()));
        npc.setMetadata("selectors", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)player.getName()));
        Editor.leave(player);
        player.getServer().getPluginManager().callEvent((Event)new NPCSelectEvent(npc, player));
    }

    private CitizensNPC getByType(EntityType type, int id, String name) {
        Class<? extends CitizensNPC> npcClass = this.types.get(type);
        if (npcClass == null) {
            throw new IllegalArgumentException("Invalid EntityType: " + type);
        }
        try {
            return npcClass.getConstructor(CitizensNPCManager.class, Integer.TYPE, String.class).newInstance(this, id, name);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

