/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.AbstractNPC;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.character.Character;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.npc.CitizensNPCManager;
import net.citizensnpcs.npc.CitizensTraitManager;
import net.citizensnpcs.npc.ai.CitizensAI;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityLiving;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryHolder;

public abstract class CitizensNPC
extends AbstractNPC {
    private final CitizensAI ai = new CitizensAI(this);
    private final CitizensNPCManager manager;
    protected EntityLiving mcEntity;
    private final CitizensTraitManager traitManager;

    protected CitizensNPC(CitizensNPCManager manager, int id, String name) {
        super(id, name);
        this.manager = manager;
        this.traitManager = (CitizensTraitManager)CitizensAPI.getTraitManager();
    }

    @Override
    public void chat(Player player, String message) {
        Messaging.sendWithNPC((CommandSender)player, Settings.Setting.CHAT_PREFIX.asString() + message, this);
    }

    @Override
    public void chat(String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.chat(player, message);
        }
    }

    protected abstract EntityLiving createHandle(Location var1);

    @Override
    public boolean despawn() {
        if (!this.isSpawned()) {
            Messaging.debug(String.format("The NPC with the ID '%d' is already despawned.", this.getId()));
            return false;
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCDespawnEvent(this));
        boolean keepSelected = this.getTrait(Spawned.class).shouldSpawn();
        if (!keepSelected) {
            this.removeMetadata("selectors", CitizensAPI.getPlugin());
        }
        this.getBukkitEntity().remove();
        this.mcEntity = null;
        return true;
    }

    @Override
    public CitizensAI getAI() {
        return this.ai;
    }

    @Override
    public LivingEntity getBukkitEntity() {
        return (LivingEntity)this.getHandle().getBukkitEntity();
    }

    public EntityLiving getHandle() {
        return this.mcEntity;
    }

    public org.bukkit.inventory.Inventory getInventory() {
        org.bukkit.inventory.Inventory inventory = Bukkit.getServer().createInventory((InventoryHolder)this, 36, StringHelper.parseColors(this.getFullName()));
        inventory.setContents(this.getTrait(Inventory.class).getContents());
        return inventory;
    }

    @Override
    public Trait getTraitFor(Class<? extends Trait> clazz) {
        return this.traitManager.getTrait(clazz, (NPC)this);
    }

    @Override
    public boolean isSpawned() {
        return this.getHandle() != null;
    }

    public void load(DataKey root) {
        Location spawnLoc;
        Character character = CitizensAPI.getCharacterManager().getCharacter(root.getString("character"));
        if (character != null) {
            try {
                character.load(root.getRelative("characters." + character.getName()));
            }
            catch (NPCLoadException e) {
                Messaging.severe(String.format("Unable to load character '%s'.", character.getName()));
                e.printStackTrace();
            }
            this.setCharacter(character);
        }
        for (DataKey traitKey : root.getRelative("traits").getSubKeys()) {
            Object trait = this.traitManager.getTrait(traitKey.name(), (NPC)this);
            if (trait == null) {
                Messaging.severe(String.format("Found missing trait '%s' while loading NPC ID: '%d' - skipped. Has the name changed?", traitKey.name(), this.getId()));
                continue;
            }
            this.addTrait((Trait)trait);
            try {
                ((Trait)this.getTrait(trait.getClass())).load(traitKey);
            }
            catch (Exception ex) {
                Messaging.log(String.format("The trait '%s' failed to load properly for NPC ID: '%d'.", traitKey.name(), this.getId()), ex.getMessage());
                ex.printStackTrace();
            }
        }
        if (this.getTrait(Spawned.class).shouldSpawn() && (spawnLoc = this.getTrait(CurrentLocation.class).getLocation()) != null) {
            this.spawn(spawnLoc);
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.manager.remove(this);
        if (this.isSpawned()) {
            this.despawn();
        }
    }

    public void save(DataKey root) {
        root.setString("name", this.getFullName());
        if (this.getCharacter() != null) {
            root.setString("character", this.getCharacter().getName());
            this.getCharacter().save(root.getRelative("characters." + this.getCharacter().getName()));
        }
        for (Trait trait : this.traits.values()) {
            trait.save(root.getRelative("traits." + trait.getName()));
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public boolean spawn(Location loc) {
        Validate.notNull((Object)loc, (String)"location cannot be null");
        if (this.isSpawned()) {
            Messaging.debug("NPC (ID: " + this.getId() + ") is already spawned.");
            return false;
        }
        NPCSpawnEvent spawnEvent = new NPCSpawnEvent(this, loc);
        Bukkit.getPluginManager().callEvent((Event)spawnEvent);
        if (spawnEvent.isCancelled()) {
            return false;
        }
        this.mcEntity = this.createHandle(loc);
        this.mcEntity.world.addEntity((Entity)this.mcEntity);
        this.mcEntity.world.players.remove(this.mcEntity);
        this.getTrait(CurrentLocation.class).setLocation(loc);
        this.getTrait(Spawned.class).setSpawned(true);
        for (Trait trait : this.traits.values()) {
            trait.onNPCSpawn();
        }
        return true;
    }

    @Override
    public void update() {
        super.update();
        this.ai.update();
    }
}

