/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.Toggleable;
import org.bukkit.entity.Sheep;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerShearEntityEvent;

public class Sheared
extends Trait
implements Toggleable,
Listener {
    private final NPC npc;
    private boolean sheared;

    public Sheared(NPC npc) {
        this.npc = npc;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        if (!(this.npc.getBukkitEntity() instanceof Sheep)) {
            throw new NPCLoadException("NPC must be a sheep to be sheared");
        }
        this.sheared = key.getBoolean("");
    }

    @Override
    public void onNPCSpawn() {
        ((Sheep)this.npc.getBukkitEntity()).setSheared(this.sheared);
    }

    @EventHandler
    public void onPlayerShearEntityEvent(PlayerShearEntityEvent event) {
        if (this.npc.equals(CitizensAPI.getNPCRegistry().getNPC(event.getEntity()))) {
            event.setCancelled(true);
        }
    }

    @Override
    public void save(DataKey key) {
        key.setBoolean("", this.sheared);
    }

    @Override
    public boolean toggle() {
        this.sheared = !this.sheared;
        ((Sheep)this.npc.getBukkitEntity()).setSheared(this.sheared);
        return this.sheared;
    }

    public String toString() {
        return "Sheared{" + this.sheared + "}";
    }
}

