/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class CurrentLocation
extends Trait
implements Runnable {
    private Location loc;

    public CurrentLocation() {
        super("location");
    }

    public Location getLocation() {
        return this.loc;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        if (Bukkit.getWorld((String)key.getString("world")) == null) {
            throw new NPCLoadException("'" + key.getString("world") + "' is not a valid world.");
        }
        this.loc = new Location(Bukkit.getWorld((String)key.getString("world")), key.getDouble("x"), key.getDouble("y"), key.getDouble("z"), (float)key.getDouble("yaw"), (float)key.getDouble("pitch"));
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        this.loc = this.npc.getBukkitEntity().getLocation();
    }

    @Override
    public void save(DataKey key) {
        if (this.loc == null) {
            key.removeKey(this.getName());
            return;
        }
        key.setString("world", this.loc.getWorld().getName());
        key.setDouble("x", this.loc.getX());
        key.setDouble("y", this.loc.getY());
        key.setDouble("z", this.loc.getZ());
        key.setDouble("yaw", this.loc.getYaw());
        key.setDouble("pitch", this.loc.getPitch());
    }

    public void setLocation(Location loc) {
        this.loc = loc;
    }

    public String toString() {
        return "CurrentLocation{" + this.loc + "}";
    }
}

