/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Storage;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlStorage
implements Storage {
    private final FileConfiguration config = new YamlConfiguration();
    private final File file;

    public YamlStorage(String fileName, String header) {
        this.file = new File(fileName);
        if (!this.file.exists()) {
            this.create();
            this.config.options().header(header);
            this.save();
        }
    }

    private void create() {
        try {
            Bukkit.getLogger().log(Level.INFO, "Creating file: " + this.file.getName());
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not create file: " + this.file.getName());
        }
    }

    @Override
    public DataKey getKey(String root) {
        return new YamlKey(root);
    }

    @Override
    public void load() {
        try {
            this.config.load(this.file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean pathExists(String key) {
        return this.config.get(key) != null;
    }

    @Override
    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String toString() {
        return "YamlStorage {file=" + this.file + "}";
    }

    public class YamlKey
    extends DataKey {
        private final String current;

        public YamlKey(String root) {
            this.current = root;
        }

        @Override
        public boolean getBoolean(String key) {
            String path = this.getKeyExt(key);
            if (YamlStorage.this.pathExists(path)) {
                if (YamlStorage.this.config.getString(path) == null) {
                    return YamlStorage.this.config.getBoolean(path);
                }
                return Boolean.parseBoolean(YamlStorage.this.config.getString(path));
            }
            return false;
        }

        @Override
        public boolean getBoolean(String key, boolean def) {
            return YamlStorage.this.config.getBoolean(this.getKeyExt(key), def);
        }

        @Override
        public double getDouble(String key) {
            String path = this.getKeyExt(key);
            if (YamlStorage.this.pathExists(path)) {
                if (YamlStorage.this.config.getString(path) == null) {
                    if (YamlStorage.this.config.get(path) instanceof Integer) {
                        return YamlStorage.this.config.getInt(path);
                    }
                    return YamlStorage.this.config.getDouble(path);
                }
                return Double.parseDouble(YamlStorage.this.config.getString(path));
            }
            return 0.0;
        }

        @Override
        public double getDouble(String key, double def) {
            return YamlStorage.this.config.getDouble(this.getKeyExt(key), def);
        }

        @Override
        public int getInt(String key) {
            String path = this.getKeyExt(key);
            if (YamlStorage.this.pathExists(path)) {
                if (YamlStorage.this.config.getString(path) == null) {
                    return YamlStorage.this.config.getInt(path);
                }
                return Integer.parseInt(YamlStorage.this.config.getString(path));
            }
            return 0;
        }

        @Override
        public int getInt(String key, int def) {
            return YamlStorage.this.config.getInt(this.getKeyExt(key), def);
        }

        private String getKeyExt(String from) {
            if (from.isEmpty()) {
                return this.current;
            }
            if (from.charAt(0) == '.') {
                return this.current.isEmpty() ? from.substring(1, from.length()) : this.current + from;
            }
            return this.current.isEmpty() ? from : this.current + "." + from;
        }

        @Override
        public long getLong(String key) {
            String path = this.getKeyExt(key);
            if (YamlStorage.this.pathExists(path)) {
                if (YamlStorage.this.config.getString(path) == null) {
                    if (YamlStorage.this.config.get(path) instanceof Integer) {
                        return YamlStorage.this.config.getInt(path);
                    }
                    return YamlStorage.this.config.getLong(path);
                }
                return Long.parseLong(YamlStorage.this.config.getString(path));
            }
            return 0L;
        }

        @Override
        public long getLong(String key, long def) {
            return YamlStorage.this.config.getLong(this.getKeyExt(key), def);
        }

        @Override
        public Object getRaw(String key) {
            return YamlStorage.this.config.get(this.getKeyExt(key));
        }

        @Override
        public DataKey getRelative(String relative) {
            if (relative == null || relative.isEmpty()) {
                return this;
            }
            return new YamlKey(this.getKeyExt(relative));
        }

        @Override
        public String getString(String key) {
            String path = this.getKeyExt(key);
            if (YamlStorage.this.pathExists(path)) {
                return YamlStorage.this.config.get(path).toString();
            }
            return "";
        }

        @Override
        public Iterable<DataKey> getSubKeys() {
            ArrayList<DataKey> res = new ArrayList<DataKey>();
            ConfigurationSection section = YamlStorage.this.config.getConfigurationSection(this.current);
            if (section == null) {
                return res;
            }
            for (String key : section.getKeys(false)) {
                res.add(this.getRelative(key));
            }
            return res;
        }

        @Override
        public boolean keyExists(String key) {
            return YamlStorage.this.config.get(this.getKeyExt(key)) != null;
        }

        @Override
        public String name() {
            int last = this.current.lastIndexOf(46);
            return this.current.substring(last == 0 ? 0 : last + 1);
        }

        @Override
        public void removeKey(String key) {
            YamlStorage.this.config.set(this.getKeyExt(key), null);
            YamlStorage.this.save();
        }

        @Override
        public void setBoolean(String key, boolean value) {
            YamlStorage.this.config.set(this.getKeyExt(key), (Object)value);
        }

        @Override
        public void setDouble(String key, double value) {
            YamlStorage.this.config.set(this.getKeyExt(key), (Object)String.valueOf(value));
        }

        @Override
        public void setInt(String key, int value) {
            YamlStorage.this.config.set(this.getKeyExt(key), (Object)value);
        }

        @Override
        public void setLong(String key, long value) {
            YamlStorage.this.config.set(this.getKeyExt(key), (Object)value);
        }

        @Override
        public void setRaw(String key, Object value) {
            YamlStorage.this.config.set(this.getKeyExt(key), value);
        }

        @Override
        public void setString(String key, String value) {
            YamlStorage.this.config.set(this.getKeyExt(key), (Object)value);
        }
    }
}

