/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Map;
import net.citizensnpcs.api.ai.EntityTarget;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationReplaceEvent;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.ai.NavigationCompleteEvent;
import net.citizensnpcs.npc.ai.PathStrategy;
import net.minecraft.server.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

public class CitizensNavigator
implements Navigator {
    private PathStrategy executing;
    private final CitizensNPC npc;
    private float speed = -1.0f;
    private static final float DEFAULT_SPEED = 0.3f;
    private static final Map<EntityType, Float> MOVEMENT_SPEEDS = Maps.newEnumMap(EntityType.class);
    private static Field SPEED_FIELD;

    public CitizensNavigator(CitizensNPC npc) {
        this.npc = npc;
    }

    @Override
    public void cancelNavigation() {
        if (this.executing != null) {
            Bukkit.getPluginManager().callEvent((Event)new NavigationCancelEvent(this));
        }
        this.executing = null;
    }

    @Override
    public EntityTarget getEntityTarget() {
        return this.executing instanceof EntityTarget ? (EntityTarget)((Object)this.executing) : null;
    }

    @Override
    public float getSpeed() {
        return this.speed;
    }

    private float getSpeedFor(EntityLiving from) {
        EntityType entityType = from.getBukkitEntity().getType();
        Float cached = MOVEMENT_SPEEDS.get(entityType);
        if (cached != null) {
            return cached.floatValue();
        }
        if (SPEED_FIELD == null) {
            MOVEMENT_SPEEDS.put(entityType, Float.valueOf(0.3f));
            return 0.3f;
        }
        try {
            float speed = SPEED_FIELD.getFloat(from);
            MOVEMENT_SPEEDS.put(entityType, Float.valueOf(speed));
            return speed;
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return 0.3f;
        }
    }

    @Override
    public Location getTargetAsLocation() {
        return this.executing.getTargetAsLocation();
    }

    @Override
    public TargetType getTargetType() {
        return this.executing.getTargetType();
    }

    @Override
    public boolean isNavigating() {
        return this.executing != null;
    }

    public void onSpawn() {
        if (this.speed == -1.0f) {
            this.speed = this.getSpeedFor(this.npc.getHandle());
        }
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
    }

    @Override
    public void setTarget(LivingEntity target, boolean aggressive) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        MCTargetStrategy newStrategy = new MCTargetStrategy(this.npc, target, aggressive, this.speed);
        this.switchStrategyTo(newStrategy);
    }

    @Override
    public void setTarget(Location target) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        MCNavigationStrategy newStrategy = new MCNavigationStrategy(this.npc, target, this.speed);
        this.switchStrategyTo(newStrategy);
    }

    private void switchStrategyTo(PathStrategy newStrategy) {
        if (this.executing != null) {
            Bukkit.getPluginManager().callEvent((Event)new NavigationReplaceEvent(this));
        }
        this.executing = newStrategy;
        Bukkit.getPluginManager().callEvent((Event)new NavigationBeginEvent(this));
    }

    public void update() {
        if (this.executing == null) {
            return;
        }
        boolean finished = this.executing.update();
        if (finished) {
            Bukkit.getPluginManager().callEvent((Event)new NavigationCompleteEvent(this));
            this.executing = null;
        }
    }

    static {
        MOVEMENT_SPEEDS.put(EntityType.IRON_GOLEM, Float.valueOf(0.15f));
        MOVEMENT_SPEEDS.put(EntityType.CHICKEN, Float.valueOf(0.25f));
        MOVEMENT_SPEEDS.put(EntityType.COW, Float.valueOf(0.2f));
        MOVEMENT_SPEEDS.put(EntityType.SHEEP, Float.valueOf(0.25f));
        MOVEMENT_SPEEDS.put(EntityType.VILLAGER, Float.valueOf(0.3f));
        MOVEMENT_SPEEDS.put(EntityType.SNOWMAN, Float.valueOf(0.25f));
        MOVEMENT_SPEEDS.put(EntityType.CREEPER, Float.valueOf(0.3f));
        try {
            SPEED_FIELD = EntityLiving.class.getDeclaredField("bb");
            SPEED_FIELD.setAccessible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

